"use strict";
(self["webpackChunk_cattr_frontend_application"] = self["webpackChunk_cattr_frontend_application"] || []).push([["resources_frontend_core_modules_UniversalReport_views_EditUniversalReport_vue"],{

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/Calendar.vue?vue&type=script&lang=js":
/*!*************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/Calendar.vue?vue&type=script&lang=js ***!
  \*************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! moment */ "./node_modules/moment/moment.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_time__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/utils/time */ "./resources/frontend/core/utils/time.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : String(i); }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


/* harmony default export */ __webpack_exports__["default"] = ({
  name: 'Calendar',
  props: {
    day: {
      type: Boolean,
      default: true
    },
    week: {
      type: Boolean,
      default: true
    },
    month: {
      type: Boolean,
      default: true
    },
    range: {
      type: Boolean,
      default: true
    },
    initialTab: {
      type: String,
      default: 'day'
    },
    sessionStorageKey: {
      type: String,
      default: 'amazingcat.session.storage'
    }
  },
  data() {
    const {
      query
    } = this.$route;
    const today = this.getDateToday();
    const data = {
      showPopup: false,
      lang: null,
      datePickerLang: {}
    };
    const sessionData = {
      type: sessionStorage.getItem(this.sessionStorageKey + '.type'),
      start: sessionStorage.getItem(this.sessionStorageKey + '.start'),
      end: sessionStorage.getItem(this.sessionStorageKey + '.end')
    };
    if (typeof query['type'] === 'string' && this.validateTab(query['type'])) {
      data.tab = query['type'];
    } else if (typeof sessionData.type === 'string' && this.validateTab(sessionData.type)) {
      data.tab = sessionData.type;
    } else {
      data.tab = this.initialTab;
    }
    if (typeof query['start'] === 'string' && this.validateDate(query['start'])) {
      data.start = query['start'];
    } else if (typeof sessionData.start === 'string' && this.validateDate(sessionData.start)) {
      data.start = sessionData.start;
    } else {
      data.start = today;
    }
    if (typeof query['end'] === 'string' && this.validateDate(query['end'])) {
      data.end = query['end'];
    } else if (typeof sessionData.end === 'string' && this.validateDate(sessionData.end)) {
      data.end = sessionData.end;
    } else {
      data.end = today;
    }
    switch (data.tab) {
      case 'day':
      case 'date':
        data.end = data.start;
        break;
      case 'week':
        {
          const date = moment__WEBPACK_IMPORTED_MODULE_0___default()(data.start, 'YYYY-MM-DD', true);
          if (date.isValid()) {
            data.start = date.startOf('isoWeek').format('YYYY-MM-DD');
            data.end = date.endOf('isoWeek').format('YYYY-MM-DD');
          }
          break;
        }
      case 'month':
        {
          const date = moment__WEBPACK_IMPORTED_MODULE_0___default()(data.start, 'YYYY-MM-DD', true);
          if (date.isValid()) {
            data.start = date.startOf('month').format('YYYY-MM-DD');
            data.end = date.endOf('month').format('YYYY-MM-DD');
          }
          break;
        }
    }
    return data;
  },
  mounted() {
    window.addEventListener('click', this.hidePopup);
    this.saveData(this.tab, this.start, this.end);
    this.emitChangeEvent();
    this.$nextTick(async () => {
      try {
        const locale = await __webpack_require__("./node_modules/vue2-datepicker/locale lazy recursive ^\\.\\/.*$")(`./${this.$i18n.locale}`);
        this.datePickerLang = _objectSpread(_objectSpread({}, locale), {}, {
          formatLocale: _objectSpread(_objectSpread({}, locale.formatLocale), {}, {
            firstDayOfWeek: 1
          }),
          monthFormat: 'MMMM'
        });
      } catch {
        this.datePickerLang = {
          formatLocale: {
            firstDayOfWeek: 1
          },
          monthFormat: 'MMMM'
        };
      }
    });
  },
  beforeDestroy() {
    window.removeEventListener('click', this.hidePopup);
  },
  computed: {
    inputValue() {
      switch (this.tab) {
        case 'date':
        default:
          return moment__WEBPACK_IMPORTED_MODULE_0___default()(this.start, 'YYYY-MM-DD').locale(this.$i18n.locale).format('MMM DD, YYYY');
        case 'week':
          {
            const start = moment__WEBPACK_IMPORTED_MODULE_0___default()(this.start, 'YYYY-MM-DD').locale(this.$i18n.locale).startOf('isoWeek');
            const end = moment__WEBPACK_IMPORTED_MODULE_0___default()(this.end, 'YYYY-MM-DD').locale(this.$i18n.locale).endOf('isoWeek');
            if (start.month() === end.month()) {
              return start.format('MMM DD-') + end.format('DD, YYYY');
            }
            return start.format('MMM DD — ') + end.format('MMM DD, YYYY');
          }
        case 'month':
          return moment__WEBPACK_IMPORTED_MODULE_0___default()(this.start, 'YYYY-MM-DD').locale(this.$i18n.locale).startOf('month').format('MMM, YYYY');
        case 'range':
          {
            const start = moment__WEBPACK_IMPORTED_MODULE_0___default()(this.start, 'YYYY-MM-DD').locale(this.$i18n.locale);
            const end = moment__WEBPACK_IMPORTED_MODULE_0___default()(this.end, 'YYYY-MM-DD').locale(this.$i18n.locale);
            if (start.year() === end.year()) {
              return start.format('MMM DD, — ') + end.format('MMM DD, YYYY');
            } else {
              return start.format('MMM DD, YYYY — ') + end.format('MMM DD, YYYY');
            }
          }
      }
    },
    datePickerType() {
      switch (this.tab) {
        case 'day':
        case 'range':
        default:
          return 'date';
        case 'week':
          return 'week';
        case 'month':
          return 'month';
      }
    },
    datePickerRange() {
      return this.tab === 'range';
    },
    datePickerValue() {
      if (this.tab === 'range') {
        return [moment__WEBPACK_IMPORTED_MODULE_0___default()(this.start, 'YYYY-MM-DD').toDate(), moment__WEBPACK_IMPORTED_MODULE_0___default()(this.end, 'YYYY-MM-DD').toDate()];
      }
      return moment__WEBPACK_IMPORTED_MODULE_0___default()(this.start, 'YYYY-MM-DD').toDate();
    }
  },
  methods: {
    getDateToday: _utils_time__WEBPACK_IMPORTED_MODULE_1__.getDateToday,
    validateTab(tab) {
      return ['day', 'date', 'week', 'month', 'range'].indexOf(tab) !== -1;
    },
    validateDate(date) {
      return moment__WEBPACK_IMPORTED_MODULE_0___default()(date, 'YYYY-MM-DD', true).isValid();
    },
    togglePopup() {
      this.showPopup = !this.showPopup;
    },
    hidePopup() {
      if (this.$el.contains(event.target)) {
        return;
      }
      this.showPopup = false;
    },
    selectPrevious() {
      let start, end;
      switch (this.tab) {
        case 'day':
        default:
          {
            const date = moment__WEBPACK_IMPORTED_MODULE_0___default()(this.start).subtract(1, 'day').format('YYYY-MM-DD');
            start = date;
            end = date;
            break;
          }
        case 'week':
          {
            const date = moment__WEBPACK_IMPORTED_MODULE_0___default()(this.start).subtract(1, 'week');
            start = date.startOf('isoWeek').format('YYYY-MM-DD');
            end = date.endOf('isoWeek').format('YYYY-MM-DD');
            break;
          }
        case 'month':
          {
            const date = moment__WEBPACK_IMPORTED_MODULE_0___default()(this.start).subtract(1, 'month');
            start = date.startOf('month').format('YYYY-MM-DD');
            end = date.endOf('month').format('YYYY-MM-DD');
            break;
          }
        case 'range':
          {
            const diff = moment__WEBPACK_IMPORTED_MODULE_0___default()(this.end).diff(this.start, 'days') + 1;
            start = moment__WEBPACK_IMPORTED_MODULE_0___default()(this.start).subtract(diff, 'days').format('YYYY-MM-DD');
            end = moment__WEBPACK_IMPORTED_MODULE_0___default()(this.end).subtract(diff, 'days').format('YYYY-MM-DD');
            break;
          }
      }
      this.saveData(this.tab, start, end);
      this.emitChangeEvent();
    },
    selectNext() {
      let start, end;
      switch (this.tab) {
        case 'day':
        default:
          {
            const date = moment__WEBPACK_IMPORTED_MODULE_0___default()(this.start).add(1, 'day').format('YYYY-MM-DD');
            start = date;
            end = date;
            break;
          }
        case 'week':
          {
            const date = moment__WEBPACK_IMPORTED_MODULE_0___default()(this.start).add(1, 'week');
            start = date.startOf('isoWeek').format('YYYY-MM-DD');
            end = date.endOf('isoWeek').format('YYYY-MM-DD');
            break;
          }
        case 'month':
          {
            const date = moment__WEBPACK_IMPORTED_MODULE_0___default()(this.start).add(1, 'month');
            start = date.startOf('month').format('YYYY-MM-DD');
            end = date.endOf('month').format('YYYY-MM-DD');
            break;
          }
        case 'range':
          {
            const diff = moment__WEBPACK_IMPORTED_MODULE_0___default()(this.end).diff(this.start, 'days') + 1;
            start = moment__WEBPACK_IMPORTED_MODULE_0___default()(this.start).add(diff, 'days').format('YYYY-MM-DD');
            end = moment__WEBPACK_IMPORTED_MODULE_0___default()(this.end).add(diff, 'days').format('YYYY-MM-DD');
            break;
          }
      }
      this.saveData(this.tab, start, end);
      this.emitChangeEvent();
    },
    onTabChange({
      index,
      name
    }) {
      this.tab = 'range';
      this.$nextTick(() => {
        this.tab = name;
      });
    },
    setDate(value) {
      let start, end;
      switch (this.tab) {
        case 'day':
        default:
          {
            const date = moment__WEBPACK_IMPORTED_MODULE_0___default()(value).format('YYYY-MM-DD');
            start = date;
            end = date;
            break;
          }
        case 'week':
          start = moment__WEBPACK_IMPORTED_MODULE_0___default()(value).startOf('isoWeek').format('YYYY-MM-DD');
          end = moment__WEBPACK_IMPORTED_MODULE_0___default()(value).endOf('isoWeek').format('YYYY-MM-DD');
          break;
        case 'month':
          start = moment__WEBPACK_IMPORTED_MODULE_0___default()(value).startOf('month').format('YYYY-MM-DD');
          end = moment__WEBPACK_IMPORTED_MODULE_0___default()(value).endOf('month').format('YYYY-MM-DD');
          break;
        case 'range':
          start = moment__WEBPACK_IMPORTED_MODULE_0___default()(value[0]).format('YYYY-MM-DD');
          end = moment__WEBPACK_IMPORTED_MODULE_0___default()(value[1]).format('YYYY-MM-DD');
          break;
      }
      this.saveData(this.tab, start, end);
      this.emitChangeEvent();
    },
    saveData(type, start, end) {
      this.tab = type;
      this.start = start;
      this.end = end;
      sessionStorage.setItem(this.sessionStorageKey + '.type', type);
      sessionStorage.setItem(this.sessionStorageKey + '.start', start);
      sessionStorage.setItem(this.sessionStorageKey + '.end', end);
      const {
        query
      } = this.$route;
      const searchParams = new URLSearchParams({
        type,
        start,
        end
      }).toString();

      // HACK: The native history is used because changing
      // params via Vue Router closes all pending requests
      history.pushState(null, null, `?${searchParams}`);
    },
    emitChangeEvent() {
      this.$emit('change', {
        type: sessionStorage.getItem(this.sessionStorageKey + '.type'),
        start: sessionStorage.getItem(this.sessionStorageKey + '.start'),
        end: sessionStorage.getItem(this.sessionStorageKey + '.end')
      });
    },
    onDateChange(value) {
      this.showPopup = false;
      this.setDate(value);
    },
    setToday() {
      this.tab = 'day';
      this.$refs.tabs.setNavByIndex(0);
      this.setDate(new Date());
      this.hidePopup();
    }
  },
  watch: {
    $route(to, from) {
      const {
        query
      } = to;
      if (typeof query['type'] === 'string' && this.validateTab(query['type'])) {
        sessionStorage.setItem(this.sessionStorageKey + '.type', this.tab = query['type']);
      }
      if (typeof query['start'] === 'string' && this.validateDate(query['start'])) {
        sessionStorage.setItem(this.sessionStorageKey + '.start', this.start = query['start']);
      }
      if (typeof query['end'] === 'string' && this.validateDate(query['end'])) {
        sessionStorage.setItem(this.sessionStorageKey + '.end', this.end = query['end']);
      }
      this.emitChangeEvent();
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=script&lang=js":
/*!*******************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=script&lang=js ***!
  \*******************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _services_resource_about_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/services/resource/about.service */ "./resources/frontend/core/services/resource/about.service.js");

const aboutService = new _services_resource_about_service__WEBPACK_IMPORTED_MODULE_0__["default"]();
/* harmony default export */ __webpack_exports__["default"] = ({
  name: 'ExportDropdown',
  props: {
    position: {
      type: String,
      default: 'bottom-left'
    },
    trigger: {
      type: String,
      default: 'click'
    }
  },
  data: () => ({
    types: []
  }),
  async created() {
    this.types = await aboutService.getReportTypes();
  },
  methods: {
    onExport(format) {
      this.$emit('export', this.types[format]);
    },
    onClose() {
      this.$emit('close');
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=script&lang=js":
/*!*******************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=script&lang=js ***!
  \*******************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _components_Calendar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/components/Calendar */ "./resources/frontend/core/components/Calendar.vue");
/* harmony import */ var _components_ExportDropdown__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/components/ExportDropdown */ "./resources/frontend/core/components/ExportDropdown.vue");
/* harmony import */ var vee_validate__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! vee-validate */ "./node_modules/vee-validate/dist/vee-validate.esm.js");
/* harmony import */ var _ObjectsDataSelect__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ObjectsDataSelect */ "./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue");
/* harmony import */ var _service_universal_report_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../service/universal-report.service */ "./resources/frontend/core/modules/UniversalReport/service/universal-report.service.js");
/* harmony import */ var _Select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Select */ "./resources/frontend/core/modules/UniversalReport/views/Select.vue");
/* harmony import */ var _FieldsSelect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./FieldsSelect */ "./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var _utils_time__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/utils/time */ "./resources/frontend/core/utils/time.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : String(i); }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }









const service = new _service_universal_report_service__WEBPACK_IMPORTED_MODULE_3__["default"]();
/* harmony default export */ __webpack_exports__["default"] = ({
  name: 'EditUniversalReport',
  components: {
    Calendar: _components_Calendar__WEBPACK_IMPORTED_MODULE_0__["default"],
    ExportDropdown: _components_ExportDropdown__WEBPACK_IMPORTED_MODULE_1__["default"],
    ValidationProvider: vee_validate__WEBPACK_IMPORTED_MODULE_7__.ValidationProvider,
    ObjDataSelect: _ObjectsDataSelect__WEBPACK_IMPORTED_MODULE_2__["default"],
    VSelect: _Select__WEBPACK_IMPORTED_MODULE_4__["default"],
    FieldsSelect: _FieldsSelect__WEBPACK_IMPORTED_MODULE_5__["default"]
  },
  data() {
    return {
      isDataLoading: false,
      projects: [],
      reportDate: null,
      projectsList: [],
      projectReportsList: {},
      base: '',
      userIds: [],
      reports: {
        personal: [{
          id: 1,
          name: 'aaaa',
          access: true
        }],
        company: [{
          id: 1,
          name: 'bbb',
          access: true
        }]
      }
    };
  },
  computed: _objectSpread(_objectSpread(_objectSpread({}, (0,vuex__WEBPACK_IMPORTED_MODULE_8__.mapGetters)('universalreport', ['name', 'service', 'bases', 'fields', 'selectedBase', 'selectedFields', 'dataObjects', 'selectedDataObjects', 'charts', 'selectedCharts', 'type'])), (0,vuex__WEBPACK_IMPORTED_MODULE_8__.mapGetters)('user', ['companyData'])), {}, {
    reportName: {
      get() {
        return this.name;
      },
      set(newName) {
        this.setName(newName);
      }
    }
  }),
  async mounted() {
    await service.getBases().then(({
      data
    }) => {
      this.setBases(data.data);
    });
    await service.show(this.$route.params.id).then(({
      data
    }) => {
      service.getDataObjectsAndFields(data.data.base).then(({
        data
      }) => {
        this.setFields(data.data.fields);
        this.setDataObjects(data.data.dataObjects);
        this.setCharts(data.data.charts);
      });
      this.setName(data.data.name);
      this.setBase(data.data.base);
      this.base = data.data.base;
      this.setSelectedFields(data.data.fields);
      this.setSelectedDataObjects(data.data.data_objects);
      this.setSelectedCharts(data.data.charts);
      this.setType(data.data.type);
    });
  },
  methods: _objectSpread(_objectSpread({}, (0,vuex__WEBPACK_IMPORTED_MODULE_8__.mapMutations)({
    setName: 'universalreport/setName',
    setBases: 'universalreport/setBases',
    setBase: 'universalreport/setBase',
    setFields: 'universalreport/setFields',
    setSelectedFields: 'universalreport/setSelectedFields',
    setDataObjects: 'universalreport/setDataObjects',
    setSelectedDataObjects: 'universalreport/setSelectedDataObject',
    setCalendarData: 'universalreport/setCalendarData',
    setCharts: 'universalreport/setCharts',
    setSelectedCharts: 'universalreport/setSelectedCharts',
    setType: 'universalreport/setType',
    clearStore: 'universalreport/clearStore'
  })), {}, {
    change(newOptions) {
      this.setSelectedDataObjects(newOptions);
    },
    changeBase(base) {
      if (this.selectedBase === base) {
        return;
      }
      this.base = base;
      this.setBase(base);
      service.getDataObjectsAndFields(base).then(({
        data
      }) => {
        this.setFields(data.data.fields);
        this.setDataObjects(data.data.dataObjects);
        this.setCharts(data.data.charts);
        let result = {};
        Object.keys(data.data.fields).forEach(item => result[item] = []);
        this.setSelectedCharts([]);
        this.setSelectedDataObjects([]);
        this.setSelectedFields(result);
      });
    },
    onCalendarChange({
      type,
      start,
      end
    }) {
      this.datepickerDateStart = (0,_utils_time__WEBPACK_IMPORTED_MODULE_6__.getStartDate)(start);
      this.datepickerDateEnd = (0,_utils_time__WEBPACK_IMPORTED_MODULE_6__.getStartDate)(end);
      this.setCalendarData({
        type,
        start,
        end
      });
    },
    onUsersSelect(uids) {
      this.userIds = uids;
      this.fetchData();
    },
    onProjectsChange(projectIDs) {
      this.projectsList = projectIDs;
      this.fetchData();
    },
    async onExport(format) {
      try {
        const {
          data
        } = await service.downloadReport((0,_utils_time__WEBPACK_IMPORTED_MODULE_6__.getStartOfDayInTimezone)(this.datepickerDateStart, this.companyData.timezone), (0,_utils_time__WEBPACK_IMPORTED_MODULE_6__.getEndOfDayInTimezone)(this.datepickerDateEnd, this.companyData.timezone), this.$route.params.id, format);
        window.open(data.data.url, '_blank');
      } catch ({
        response
      }) {
        if (true) {
          console.log(response ? response : 'request to reports is canceled');
        }
      }
    },
    onFieldsChange(fields) {
      console.log(fields);
      this.setSelectedFields(fields);
    },
    selectReport(id) {
      console.log(id);
    },
    onChartsChange(charts) {
      this.setSelectedCharts(charts);
    },
    async edit() {
      if (!this.name || !this.base || this.selectedDataObjects.length === 0) {
        this.$Notify({
          type: 'warning',
          title: this.$t('universal-report.warning.title'),
          message: this.$t('universal-report.warning.empty')
        });
        return;
      }
      try {
        await service.edit(this.$route.params.id, {
          name: this.name,
          base: this.selectedBase,
          fields: this.selectedFields,
          dataObjects: this.selectedDataObjects,
          charts: this.selectedCharts,
          type: this.type
        });
        this.$Notify({
          type: 'success',
          title: this.$t('notification.save.success.title'),
          message: this.$t('notification.save.success.message')
        });
      } catch (error) {
        this.$Notify({
          type: 'error',
          title: this.$t('notification.save.error.title'),
          message: this.$t('notification.save.error.message')
        });
      }
    },
    async remove() {
      try {
        await service.deleteItem(this.$route.params.id);
        this.$Notify({
          type: 'success',
          title: this.$t('notification.record.delete.success.title'),
          message: this.$t('notification.record.delete.success.message')
        });
        this.$router.push({
          name: 'report.universal'
        });
      } catch (error) {
        this.$Notify({
          type: 'error',
          title: this.$t('notification.record.delete.error.title'),
          message: this.$t('notification.record.delete.error.message')
        });
      }
    }
  })
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=script&lang=js":
/*!************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=script&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _components_Preloader__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/components/Preloader */ "./resources/frontend/core/components/Preloader.vue");
/* harmony import */ var lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/cloneDeep */ "./node_modules/lodash/cloneDeep.js");
/* harmony import */ var lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : String(i); }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }



/* harmony default export */ __webpack_exports__["default"] = ({
  name: 'FieldsSelect',
  components: {
    Preloader: _components_Preloader__WEBPACK_IMPORTED_MODULE_0__["default"]
  },
  props: {
    options: {
      type: Object,
      default: () => {},
      required: true
    },
    selectedOptions: {
      type: Object,
      default: () => {},
      required: false
    },
    size: {
      type: String,
      default: 'normal'
    },
    localePath: {
      type: String,
      default: () => '',
      required: true
    }
  },
  data() {
    return {
      showPopup: false,
      searchValue: '',
      isLoading: false
    };
  },
  methods: {
    selectAll() {
      if (JSON.stringify(this.options) !== JSON.stringify(this.selectedOptions)) {
        this.$emit('on-change', this.options);
      }
    },
    toggle(option, key) {
      let selectedOptions = lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_1___default()(this.selectedOptions);
      if (selectedOptions[key].includes(option)) {
        selectedOptions[key] = selectedOptions[key].filter(item => item !== option);
        this.$emit('on-change', selectedOptions);
      } else {
        selectedOptions[key].push(option);
        this.$emit('on-change', selectedOptions);
      }
    },
    clearSelection() {
      this.$emit('on-change', []);
    },
    togglePopup() {
      this.showPopup = !this.showPopup;
      if (!this.showPopup) {
        this.$emit('on-change', this.selectedOptions);
      }
    },
    hidePopup() {
      if (this.$el.contains(event.target)) {
        return;
      }
      this.showPopup = false;
      this.$emit('on-change', this.selectedOptions);
    }
  },
  computed: _objectSpread(_objectSpread({}, (0,vuex__WEBPACK_IMPORTED_MODULE_2__.mapGetters)('universalreport', ['selectedBase'])), {}, {
    inputValue() {
      let count = 0;
      let selectedFields = {};
      Object.assign(selectedFields, this.selectedOptions);
      Object.keys(selectedFields).forEach(key => count += selectedFields[key].length);
      return this.$tc('control.element_selected', count, {
        count: count
      });
    },
    filteredOptions() {
      let result = {};
      Object.keys(this.options).forEach(key => {
        return result[key] = this.options[key].filter(option => {
          let name = option.toUpperCase();
          const value = this.searchValue.toUpperCase();
          return name.indexOf(value) !== -1;
        });
      });
      return result;
    }
  }),
  created() {
    window.addEventListener('click', this.hidePopup);
  },
  beforeDestroy() {
    window.removeEventListener('click', this.hidePopup);
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=script&lang=js":
/*!*****************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=script&lang=js ***!
  \*****************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _components_UserAvatar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/components/UserAvatar */ "./resources/frontend/core/components/UserAvatar.vue");
/* harmony import */ var _components_Preloader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/components/Preloader */ "./resources/frontend/core/components/Preloader.vue");


/* harmony default export */ __webpack_exports__["default"] = ({
  name: 'ObjDataSelect',
  components: {
    UserAvatar: _components_UserAvatar__WEBPACK_IMPORTED_MODULE_0__["default"],
    Preloader: _components_Preloader__WEBPACK_IMPORTED_MODULE_1__["default"]
  },
  props: {
    base: {
      type: String,
      default: () => '',
      required: false
    },
    options: {
      type: Array,
      default: () => [],
      required: true
    },
    selectedOptions: {
      type: Array,
      default: () => [],
      required: false
    },
    size: {
      type: String,
      default: 'normal'
    }
  },
  data() {
    return {
      showPopup: false,
      searchValue: '',
      isLoading: false
    };
  },
  methods: {
    selectAll() {
      // If some users already selected we are going to clear it
      if (!this.selectedOptions.length) {
        this.$emit('on-change', this.selectedOptions.concat(this.options.filter(option => {
          let name = typeof option.name !== 'undefined' ? option.name : option.full_name;
          return name.toUpperCase().indexOf(this.searchValue.toUpperCase()) !== -1;
        }).map(({
          id
        }) => id).filter(id => !this.selectedOptions.includes(id))));
      } else {
        this.$emit('on-change', this.selectedOptions.filter(pid => !this.options.map(({
          id
        }) => id).includes(pid)));
      }
    },
    toggle(id) {
      if (this.selectedOptions.includes(id)) {
        this.$emit('on-change', this.selectedOptions.filter(i => i !== id));
      } else {
        let selectedOptions = this.selectedOptions.slice(0);
        selectedOptions.push(id);
        this.$emit('on-change', selectedOptions);
      }
    },
    clearSelection() {
      this.$emit('on-change', []);
    },
    togglePopup() {
      this.showPopup = !this.showPopup;
      if (!this.showPopup) {
        this.$emit('on-change', this.selectedOptions);
      }
    },
    hidePopup() {
      if (this.$el.contains(event.target)) {
        return;
      }
      this.showPopup = false;
      this.$emit('on-change', this.selectedOptions);
    }
  },
  computed: {
    inputValue() {
      return this.$tc('control.element_selected', this.selectedOptions.length, {
        count: this.selectedOptions.length
      });
    },
    filteredOptions() {
      return this.options.filter(option => {
        let name = typeof option.name !== 'undefined' ? option.name.toUpperCase() : option.full_name.toUpperCase();
        const value = this.searchValue.toUpperCase();
        return name.indexOf(value) !== -1;
      });
    }
  },
  created() {
    window.addEventListener('click', this.hidePopup);
  },
  beforeDestroy() {
    window.removeEventListener('click', this.hidePopup);
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=script&lang=js":
/*!******************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=script&lang=js ***!
  \******************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _components_Preloader__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/components/Preloader */ "./resources/frontend/core/components/Preloader.vue");

/* harmony default export */ __webpack_exports__["default"] = ({
  name: 'VSelect',
  components: {
    Preloader: _components_Preloader__WEBPACK_IMPORTED_MODULE_0__["default"]
  },
  props: {
    options: {
      type: Array,
      default: () => [],
      required: true
    },
    selectedOptions: {
      type: Array,
      default: () => [],
      required: false
    },
    size: {
      type: String,
      default: 'normal'
    },
    localePath: {
      type: String,
      default: () => '',
      required: true
    }
  },
  data() {
    return {
      showPopup: false,
      searchValue: '',
      isLoading: false
    };
  },
  methods: {
    selectAll() {
      // If some users already selected we are going to clear it
      if (!this.selectedOptions.length) {
        this.$emit('on-change', this.selectedOptions.concat(this.options.filter(option => {
          let name = option;
          return name.toUpperCase().indexOf(this.searchValue.toUpperCase()) !== -1;
        }).filter(option => !this.selectedOptions.includes(option))));
      } else {
        this.$emit('on-change', this.selectedOptions.filter(option => !this.options.map(item => item).includes(option)));
      }
    },
    toggle(option) {
      if (this.selectedOptions.includes(option)) {
        this.$emit('on-change', this.selectedOptions.filter(item => item !== option));
      } else {
        let selectedOptions = this.selectedOptions.slice(0);
        selectedOptions.push(option);
        this.$emit('on-change', selectedOptions);
      }
    },
    clearSelection() {
      this.$emit('on-change', []);
    },
    togglePopup() {
      this.showPopup = !this.showPopup;
      if (!this.showPopup) {
        this.$emit('on-change', this.selectedOptions);
      }
    },
    hidePopup() {
      if (this.$el.contains(event.target)) {
        return;
      }
      this.showPopup = false;
      this.$emit('on-change', this.selectedOptions);
    }
  },
  computed: {
    inputValue() {
      return this.$tc('control.element_selected', this.selectedOptions.length, {
        count: this.selectedOptions.length
      });
    },
    filteredOptions() {
      return this.options.filter(option => {
        let name = option.toUpperCase();
        const value = this.searchValue.toUpperCase();
        return name.indexOf(value) !== -1;
      });
    }
  },
  created() {
    window.addEventListener('click', this.hidePopup);
  },
  beforeDestroy() {
    window.removeEventListener('click', this.hidePopup);
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/Calendar.vue?vue&type=template&id=2aad669c&scoped=true":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/Calendar.vue?vue&type=template&id=2aad669c&scoped=true ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* binding */ render; },
/* harmony export */   staticRenderFns: function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', {
    staticClass: "calendar",
    on: {
      "click": _vm.togglePopup
    }
  }, [_c('at-input', {
    staticClass: "input",
    attrs: {
      "readonly": true,
      "value": _vm.inputValue
    },
    scopedSlots: _vm._u([{
      key: "prepend",
      fn: function () {
        return [_c('i', {
          staticClass: "icon icon-chevron-left previous",
          on: {
            "click": function ($event) {
              $event.stopPropagation();
              $event.preventDefault();
              return _vm.selectPrevious.apply(null, arguments);
            }
          }
        })];
      },
      proxy: true
    }, {
      key: "append",
      fn: function () {
        return [_c('i', {
          staticClass: "icon icon-chevron-right next",
          on: {
            "click": function ($event) {
              $event.stopPropagation();
              $event.preventDefault();
              return _vm.selectNext.apply(null, arguments);
            }
          }
        })];
      },
      proxy: true
    }])
  }), _vm._v(" "), _c('span', {
    staticClass: "calendar-icon icon icon-calendar"
  }), _vm._v(" "), _c('transition', {
    attrs: {
      "name": "slide-up"
    }
  }, [_c('div', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.showPopup,
      expression: "showPopup"
    }],
    class: {
      'datepicker-wrapper': true,
      'datepicker-wrapper--range': _vm.datePickerRange,
      'at-select__dropdown at-select__dropdown--bottom': true
    },
    on: {
      "click": function ($event) {
        $event.stopPropagation();
      }
    }
  }, [_c('div', [_c('at-tabs', {
    ref: "tabs",
    on: {
      "on-change": _vm.onTabChange
    },
    model: {
      value: _vm.tab,
      callback: function ($$v) {
        _vm.tab = $$v;
      },
      expression: "tab"
    }
  }, [_vm.day ? _c('at-tab-pane', {
    attrs: {
      "label": _vm.$t('control.day'),
      "name": "day"
    }
  }) : _vm._e(), _vm._v(" "), _vm.week ? _c('at-tab-pane', {
    attrs: {
      "label": _vm.$t('control.week'),
      "name": "week"
    }
  }) : _vm._e(), _vm._v(" "), _vm.month ? _c('at-tab-pane', {
    attrs: {
      "label": _vm.$t('control.month'),
      "name": "month"
    }
  }) : _vm._e(), _vm._v(" "), _vm.range ? _c('at-tab-pane', {
    attrs: {
      "label": _vm.$t('control.range'),
      "name": "range"
    }
  }) : _vm._e()], 1)], 1), _vm._v(" "), _c('date-picker', {
    key: _vm.$i18n.locale,
    staticClass: "datepicker",
    attrs: {
      "append-to-body": false,
      "clearable": false,
      "editable": false,
      "inline": true,
      "lang": _vm.datePickerLang,
      "type": _vm.datePickerType,
      "range": _vm.datePickerRange,
      "value": _vm.datePickerValue
    },
    on: {
      "change": _vm.onDateChange
    },
    scopedSlots: _vm._u([{
      key: "footer",
      fn: function () {
        return [_vm.day ? _c('div', {
          staticClass: "datepicker__footer"
        }, [_c('button', {
          staticClass: "mx-btn mx-btn-text",
          attrs: {
            "size": "small"
          },
          on: {
            "click": _vm.setToday
          }
        }, [_vm._v("\n                            " + _vm._s(_vm.$t('control.today')) + "\n                        ")])]) : _vm._e()];
      },
      proxy: true
    }])
  })], 1)])], 1);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=template&id=d02fc97a&scoped=true":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=template&id=d02fc97a&scoped=true ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* binding */ render; },
/* harmony export */   staticRenderFns: function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', {
    staticClass: "dropdown"
  }, [_c('at-dropdown', {
    attrs: {
      "placement": _vm.position,
      "trigger": _vm.trigger
    },
    on: {
      "on-dropdown-command": _vm.onExport
    }
  }, [_c('at-button', {
    attrs: {
      "type": "text"
    }
  }, [_c('span', {
    staticClass: "icon icon-save"
  })]), _vm._v(" "), _c('at-dropdown-menu', {
    attrs: {
      "slot": "menu"
    },
    slot: "menu"
  }, _vm._l(_vm.types, function (type, key) {
    return _c('at-dropdown-item', {
      key: key,
      attrs: {
        "name": key
      }
    }, [_vm._v(_vm._s(key.toUpperCase()))]);
  }), 1)], 1)], 1);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=template&id=289c8081&scoped=true":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=template&id=289c8081&scoped=true ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* binding */ render; },
/* harmony export */   staticRenderFns: function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', {
    staticClass: "universal-report__form"
  }, [_c('div', {
    staticClass: "data-entry controls-row"
  }, [_c('Calendar', {
    staticClass: "controls-row__item",
    attrs: {
      "sessionStorageKey": "amazingcat.session.storage.universalreport"
    },
    on: {
      "change": _vm.onCalendarChange
    }
  }), _vm._v(" "), _c('div', {
    staticClass: "controls-row__item controls-row__item--left-auto"
  }, [_vm.companyData.timezone ? _c('small', [_vm._v("\n                " + _vm._s(_vm.$t('universal-report.report_timezone', [_vm.companyData.timezone])) + "\n            ")]) : _vm._e()]), _vm._v(" "), _c('ExportDropdown', {
    staticClass: "export-btn dropdown controls-row__btn controls-row__item",
    attrs: {
      "position": "left-top",
      "trigger": "hover"
    },
    on: {
      "export": _vm.onExport
    }
  })], 1), _vm._v(" "), _c('validation-provider', {
    attrs: {
      "rules": 'required',
      "name": _vm.$t('field.name')
    },
    scopedSlots: _vm._u([{
      key: "default",
      fn: function ({
        errors
      }) {
        return [_c('at-input', {
          staticClass: "data-entry",
          attrs: {
            "placeholder": _vm.$t('field.name'),
            "type": 'text',
            "status": errors.length > 0 ? 'error' : ''
          },
          model: {
            value: _vm.reportName,
            callback: function ($$v) {
              _vm.reportName = $$v;
            },
            expression: "reportName"
          }
        }), _vm._v(" "), _c('small', [_vm._v(_vm._s(errors[0]))])];
      }
    }])
  }), _vm._v(" "), _c('at-select', {
    staticClass: "data-entry",
    attrs: {
      "value": _vm.base
    },
    on: {
      "on-change": _vm.changeBase
    }
  }, _vm._l(_vm.bases, function (base) {
    return _c('at-option', {
      key: base,
      attrs: {
        "value": base,
        "label": _vm.$t(`field.data-objects.${base}.1`)
      }
    });
  }), 1), _vm._v(" "), _vm.base ? _c('div', [_c('label', [_vm._v(_vm._s(_vm.$t(`field.data-objects.${_vm.base}.1`)))])]) : _vm._e(), _vm._v(" "), _c('obj-data-select', {
    staticClass: "data-entry",
    attrs: {
      "options": _vm.dataObjects,
      "base": _vm.selectedBase,
      "selectedOptions": _vm.selectedDataObjects
    },
    on: {
      "on-change": _vm.change
    }
  }), _vm._v(" "), _vm.base ? _c('div', [_c('label', [_vm._v(_vm._s(_vm.$t(`field.data-objects.${_vm.base}.2`)))])]) : _vm._e(), _vm._v(" "), _c('fields-select', {
    staticClass: "data-entry",
    attrs: {
      "localePath": "field.fields",
      "options": _vm.fields,
      "selectedOptions": _vm.selectedFields
    },
    on: {
      "on-change": _vm.onFieldsChange
    }
  }), _vm._v(" "), _vm.base ? _c('div', [_c('label', [_vm._v(_vm._s(_vm.$t(`field.data-objects.${_vm.base}.3`)))])]) : _vm._e(), _vm._v(" "), _c('v-select', {
    staticClass: "data-entry",
    attrs: {
      "localePath": `field.fields.${_vm.selectedBase}.charts`,
      "options": _vm.charts,
      "selectedOptions": _vm.selectedCharts
    },
    on: {
      "on-change": _vm.onChartsChange
    }
  }), _vm._v(" "), _c('div', {
    staticClass: "controls-row"
  }, [_c('at-button', {
    staticClass: "controls-row__item",
    attrs: {
      "type": "primary"
    },
    on: {
      "click": _vm.edit
    }
  }, [_vm._v(_vm._s(_vm.$t('universal-report.save')))]), _vm._v(" "), _c('at-button', {
    staticClass: "controls-row__item",
    attrs: {
      "type": "success"
    }
  }, [_c('router-link', {
    staticClass: "link",
    attrs: {
      "to": {
        name: 'report.universal.view',
        params: {
          id: this.$route.params.id
        }
      }
    }
  }, [_vm._v("\n                " + _vm._s(_vm.$t('universal-report.generate')) + "\n            ")])], 1), _vm._v(" "), _c('at-button', {
    staticClass: "controls-row__item",
    attrs: {
      "type": "error"
    },
    on: {
      "click": _vm.remove
    }
  }, [_vm._v(_vm._s(_vm.$t('universal-report.remove')))])], 1)], 1);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=template&id=49e1298e&scoped=true":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=template&id=49e1298e&scoped=true ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* binding */ render; },
/* harmony export */   staticRenderFns: function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', {
    staticClass: "select",
    class: {
      'at-select--visible': _vm.showPopup
    },
    on: {
      "click": _vm.togglePopup
    }
  }, [_c('at-input', {
    staticClass: "select-input",
    attrs: {
      "readonly": true,
      "value": _vm.inputValue,
      "size": _vm.size
    }
  }), _vm._v(" "), _c('span', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.selectedOptions.length,
      expression: "selectedOptions.length"
    }],
    staticClass: "select__clear icon icon-x at-select__clear",
    on: {
      "click": _vm.clearSelection
    }
  }), _vm._v(" "), _c('span', {
    staticClass: "icon icon-chevron-down at-select__arrow"
  }), _vm._v(" "), _c('div', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.showPopup,
      expression: "showPopup"
    }],
    staticClass: "at-select__dropdown at-select__dropdown--bottom",
    on: {
      "click": function ($event) {
        $event.stopPropagation();
      }
    }
  }, [_c('div', {
    staticClass: "search"
  }, [_c('at-input', {
    staticClass: "search-input",
    attrs: {
      "placeholder": _vm.$t('control.search')
    },
    model: {
      value: _vm.searchValue,
      callback: function ($$v) {
        _vm.searchValue = $$v;
      },
      expression: "searchValue"
    }
  })], 1), _vm._v(" "), _c('div', {
    staticClass: "select-all",
    on: {
      "click": _vm.selectAll
    }
  }, [_c('span', [_vm._v(_vm._s(_vm.$t(_vm.selectedOptions.length ? 'control.clear_all' : 'control.select_all')))])]), _vm._v(" "), _c('div', {
    staticClass: "select-list"
  }, [_vm.isLoading ? _c('preloader') : _vm._e(), _vm._v(" "), _c('ul', _vm._l(_vm.filteredOptions, function (o, key) {
    return _c('div', {
      key: key
    }, [_c('p', [_vm._v(_vm._s(_vm.$t(`universal-report.${key}`)))]), _vm._v(" "), _vm._l(o, function (option) {
      return _c('li', {
        key: option,
        class: {
          'select-item': true,
          active: _vm.selectedOptions[key].includes(option)
        },
        on: {
          "click": function ($event) {
            return _vm.toggle(option, key);
          }
        }
      }, [_c('div', {
        staticClass: "name"
      }, [_vm._v("\n                            " + _vm._s(_vm.$t(`${_vm.localePath}.${_vm.selectedBase}.${key}.${option}`)) + "\n                        ")])]);
    })], 2);
  }), 0)], 1)])], 1);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=template&id=2a42f486&scoped=true":
/*!****************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=template&id=2a42f486&scoped=true ***!
  \****************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* binding */ render; },
/* harmony export */   staticRenderFns: function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', {
    staticClass: "select",
    class: {
      'at-select--visible': _vm.showPopup
    },
    on: {
      "click": _vm.togglePopup
    }
  }, [_c('at-input', {
    staticClass: "select-input",
    attrs: {
      "readonly": true,
      "value": _vm.inputValue,
      "size": _vm.size
    }
  }), _vm._v(" "), _c('span', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.selectedOptions.length,
      expression: "selectedOptions.length"
    }],
    staticClass: "select__clear icon icon-x at-select__clear",
    on: {
      "click": _vm.clearSelection
    }
  }), _vm._v(" "), _c('span', {
    staticClass: "icon icon-chevron-down at-select__arrow"
  }), _vm._v(" "), _c('div', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.showPopup,
      expression: "showPopup"
    }],
    staticClass: "at-select__dropdown at-select__dropdown--bottom",
    on: {
      "click": function ($event) {
        $event.stopPropagation();
      }
    }
  }, [_c('div', {
    staticClass: "search"
  }, [_c('at-input', {
    staticClass: "search-input",
    attrs: {
      "placeholder": _vm.$t('control.search')
    },
    model: {
      value: _vm.searchValue,
      callback: function ($$v) {
        _vm.searchValue = $$v;
      },
      expression: "searchValue"
    }
  })], 1), _vm._v(" "), _c('div', {
    staticClass: "select-all",
    on: {
      "click": _vm.selectAll
    }
  }, [_c('span', [_vm._v(_vm._s(_vm.$t(_vm.selectedOptions.length ? 'control.clear_all' : 'control.select_all')))])]), _vm._v(" "), _c('div', {
    staticClass: "select-list"
  }, [_vm.isLoading ? _c('preloader') : _vm._e(), _vm._v(" "), _c('ul', _vm._l(_vm.filteredOptions, function (option) {
    return _c('li', {
      key: option.id,
      class: {
        'select-item': true,
        active: _vm.selectedOptions.includes(option.id)
      },
      on: {
        "click": function ($event) {
          return _vm.toggle(option.id);
        }
      }
    }, [_vm.base === 'user' ? _c('UserAvatar', {
      staticClass: "user-avatar",
      attrs: {
        "size": 25,
        "borderRadius": 5,
        "user": option,
        "online": option.online
      }
    }) : _vm._e(), _vm._v(" "), _c('div', {
      staticClass: "name"
    }, [_vm._v("\n                        " + _vm._s(typeof option.name !== 'undefined' ? option.name : option.full_name) + "\n                    ")])], 1);
  }), 0)], 1)])], 1);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=template&id=7ed046c0&scoped=true":
/*!*****************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=template&id=7ed046c0&scoped=true ***!
  \*****************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* binding */ render; },
/* harmony export */   staticRenderFns: function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', {
    staticClass: "select",
    class: {
      'at-select--visible': _vm.showPopup
    },
    on: {
      "click": _vm.togglePopup
    }
  }, [_c('at-input', {
    staticClass: "select-input",
    attrs: {
      "readonly": true,
      "value": _vm.inputValue,
      "size": _vm.size
    }
  }), _vm._v(" "), _c('span', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.selectedOptions.length,
      expression: "selectedOptions.length"
    }],
    staticClass: "select__clear icon icon-x at-select__clear",
    on: {
      "click": _vm.clearSelection
    }
  }), _vm._v(" "), _c('span', {
    staticClass: "icon icon-chevron-down at-select__arrow"
  }), _vm._v(" "), _c('div', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.showPopup,
      expression: "showPopup"
    }],
    staticClass: "at-select__dropdown at-select__dropdown--bottom",
    on: {
      "click": function ($event) {
        $event.stopPropagation();
      }
    }
  }, [_c('div', {
    staticClass: "search"
  }, [_c('at-input', {
    staticClass: "search-input",
    attrs: {
      "placeholder": _vm.$t('control.search')
    },
    model: {
      value: _vm.searchValue,
      callback: function ($$v) {
        _vm.searchValue = $$v;
      },
      expression: "searchValue"
    }
  })], 1), _vm._v(" "), _c('div', {
    staticClass: "select-all",
    on: {
      "click": _vm.selectAll
    }
  }, [_c('span', [_vm._v(_vm._s(_vm.$t(_vm.selectedOptions.length ? 'control.clear_all' : 'control.select_all')))])]), _vm._v(" "), _c('div', {
    staticClass: "select-list"
  }, [_vm.isLoading ? _c('preloader') : _vm._e(), _vm._v(" "), _c('ul', _vm._l(_vm.filteredOptions, function (option) {
    return _c('li', {
      key: option,
      class: {
        'select-item': true,
        active: _vm.selectedOptions.includes(option)
      },
      on: {
        "click": function ($event) {
          return _vm.toggle(option);
        }
      }
    }, [_c('div', {
      staticClass: "name"
    }, [_vm._v("\n                        " + _vm._s(_vm.$t(`${_vm.localePath}.${option}`)) + "\n                    ")])]);
  }), 0)], 1)])], 1);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./resources/frontend/core/services/resource/about.service.js":
/*!********************************************************************!*\
  !*** ./resources/frontend/core/services/resource/about.service.js ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ AboutService; }
/* harmony export */ });
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! axios */ "./node_modules/axios/lib/axios.js");

class AboutService {
  async getGeneralInfo() {
    const result = await axios__WEBPACK_IMPORTED_MODULE_0__["default"].get('about');
    return result.data;
  }
  async getStorageInfo() {
    const result = await axios__WEBPACK_IMPORTED_MODULE_0__["default"].get('about/storage');
    return result.data.data;
  }
  startCleanup() {
    return axios__WEBPACK_IMPORTED_MODULE_0__["default"].post('about/storage');
  }
  async getReportTypes() {
    const result = await axios__WEBPACK_IMPORTED_MODULE_0__["default"].get('about/reports');
    return result.data.data.types;
  }
}

/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/Calendar.vue?vue&type=style&index=0&id=2aad669c&lang=scss&scoped=true":
/*!****************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/Calendar.vue?vue&type=style&index=0&id=2aad669c&lang=scss&scoped=true ***!
  \****************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=style&index=0&id=d02fc97a&lang=scss&scoped=true":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=style&index=0&id=d02fc97a&lang=scss&scoped=true ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=style&index=0&id=289c8081&lang=scss&scoped=true":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=style&index=0&id=289c8081&lang=scss&scoped=true ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=style&index=0&id=49e1298e&lang=scss&scoped=true":
/*!***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=style&index=0&id=49e1298e&lang=scss&scoped=true ***!
  \***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=style&index=0&id=2a42f486&lang=scss&scoped=true":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=style&index=0&id=2a42f486&lang=scss&scoped=true ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=style&index=0&id=7ed046c0&lang=scss&scoped=true":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=style&index=0&id=7ed046c0&lang=scss&scoped=true ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./resources/frontend/core/components/Calendar.vue":
/*!*********************************************************!*\
  !*** ./resources/frontend/core/components/Calendar.vue ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Calendar_vue_vue_type_template_id_2aad669c_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Calendar.vue?vue&type=template&id=2aad669c&scoped=true */ "./resources/frontend/core/components/Calendar.vue?vue&type=template&id=2aad669c&scoped=true");
/* harmony import */ var _Calendar_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Calendar.vue?vue&type=script&lang=js */ "./resources/frontend/core/components/Calendar.vue?vue&type=script&lang=js");
/* harmony import */ var _Calendar_vue_vue_type_style_index_0_id_2aad669c_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Calendar.vue?vue&type=style&index=0&id=2aad669c&lang=scss&scoped=true */ "./resources/frontend/core/components/Calendar.vue?vue&type=style&index=0&id=2aad669c&lang=scss&scoped=true");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _Calendar_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _Calendar_vue_vue_type_template_id_2aad669c_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render,
  _Calendar_vue_vue_type_template_id_2aad669c_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "2aad669c",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/frontend/core/components/Calendar.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/frontend/core/components/ExportDropdown.vue":
/*!***************************************************************!*\
  !*** ./resources/frontend/core/components/ExportDropdown.vue ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _ExportDropdown_vue_vue_type_template_id_d02fc97a_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ExportDropdown.vue?vue&type=template&id=d02fc97a&scoped=true */ "./resources/frontend/core/components/ExportDropdown.vue?vue&type=template&id=d02fc97a&scoped=true");
/* harmony import */ var _ExportDropdown_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ExportDropdown.vue?vue&type=script&lang=js */ "./resources/frontend/core/components/ExportDropdown.vue?vue&type=script&lang=js");
/* harmony import */ var _ExportDropdown_vue_vue_type_style_index_0_id_d02fc97a_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ExportDropdown.vue?vue&type=style&index=0&id=d02fc97a&lang=scss&scoped=true */ "./resources/frontend/core/components/ExportDropdown.vue?vue&type=style&index=0&id=d02fc97a&lang=scss&scoped=true");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _ExportDropdown_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _ExportDropdown_vue_vue_type_template_id_d02fc97a_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render,
  _ExportDropdown_vue_vue_type_template_id_d02fc97a_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "d02fc97a",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/frontend/core/components/ExportDropdown.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue":
/*!***************************************************************************************!*\
  !*** ./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _EditUniversalReport_vue_vue_type_template_id_289c8081_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EditUniversalReport.vue?vue&type=template&id=289c8081&scoped=true */ "./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=template&id=289c8081&scoped=true");
/* harmony import */ var _EditUniversalReport_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./EditUniversalReport.vue?vue&type=script&lang=js */ "./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=script&lang=js");
/* harmony import */ var _EditUniversalReport_vue_vue_type_style_index_0_id_289c8081_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./EditUniversalReport.vue?vue&type=style&index=0&id=289c8081&lang=scss&scoped=true */ "./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=style&index=0&id=289c8081&lang=scss&scoped=true");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _EditUniversalReport_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _EditUniversalReport_vue_vue_type_template_id_289c8081_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render,
  _EditUniversalReport_vue_vue_type_template_id_289c8081_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "289c8081",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue":
/*!********************************************************************************!*\
  !*** ./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _FieldsSelect_vue_vue_type_template_id_49e1298e_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FieldsSelect.vue?vue&type=template&id=49e1298e&scoped=true */ "./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=template&id=49e1298e&scoped=true");
/* harmony import */ var _FieldsSelect_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FieldsSelect.vue?vue&type=script&lang=js */ "./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=script&lang=js");
/* harmony import */ var _FieldsSelect_vue_vue_type_style_index_0_id_49e1298e_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FieldsSelect.vue?vue&type=style&index=0&id=49e1298e&lang=scss&scoped=true */ "./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=style&index=0&id=49e1298e&lang=scss&scoped=true");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _FieldsSelect_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _FieldsSelect_vue_vue_type_template_id_49e1298e_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render,
  _FieldsSelect_vue_vue_type_template_id_49e1298e_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "49e1298e",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue":
/*!*************************************************************************************!*\
  !*** ./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _ObjectsDataSelect_vue_vue_type_template_id_2a42f486_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ObjectsDataSelect.vue?vue&type=template&id=2a42f486&scoped=true */ "./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=template&id=2a42f486&scoped=true");
/* harmony import */ var _ObjectsDataSelect_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ObjectsDataSelect.vue?vue&type=script&lang=js */ "./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=script&lang=js");
/* harmony import */ var _ObjectsDataSelect_vue_vue_type_style_index_0_id_2a42f486_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ObjectsDataSelect.vue?vue&type=style&index=0&id=2a42f486&lang=scss&scoped=true */ "./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=style&index=0&id=2a42f486&lang=scss&scoped=true");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _ObjectsDataSelect_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _ObjectsDataSelect_vue_vue_type_template_id_2a42f486_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render,
  _ObjectsDataSelect_vue_vue_type_template_id_2a42f486_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "2a42f486",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/frontend/core/modules/UniversalReport/views/Select.vue":
/*!**************************************************************************!*\
  !*** ./resources/frontend/core/modules/UniversalReport/views/Select.vue ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Select_vue_vue_type_template_id_7ed046c0_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Select.vue?vue&type=template&id=7ed046c0&scoped=true */ "./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=template&id=7ed046c0&scoped=true");
/* harmony import */ var _Select_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Select.vue?vue&type=script&lang=js */ "./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=script&lang=js");
/* harmony import */ var _Select_vue_vue_type_style_index_0_id_7ed046c0_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Select.vue?vue&type=style&index=0&id=7ed046c0&lang=scss&scoped=true */ "./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=style&index=0&id=7ed046c0&lang=scss&scoped=true");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _Select_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _Select_vue_vue_type_template_id_7ed046c0_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render,
  _Select_vue_vue_type_template_id_7ed046c0_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "7ed046c0",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/frontend/core/modules/UniversalReport/views/Select.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/frontend/core/components/Calendar.vue?vue&type=script&lang=js":
/*!*********************************************************************************!*\
  !*** ./resources/frontend/core/components/Calendar.vue?vue&type=script&lang=js ***!
  \*********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_Calendar_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Calendar.vue?vue&type=script&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/Calendar.vue?vue&type=script&lang=js");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_Calendar_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/frontend/core/components/ExportDropdown.vue?vue&type=script&lang=js":
/*!***************************************************************************************!*\
  !*** ./resources/frontend/core/components/ExportDropdown.vue?vue&type=script&lang=js ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ExportDropdown_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ExportDropdown.vue?vue&type=script&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=script&lang=js");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ExportDropdown_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=script&lang=js":
/*!***************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=script&lang=js ***!
  \***************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_EditUniversalReport_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./EditUniversalReport.vue?vue&type=script&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=script&lang=js");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_EditUniversalReport_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=script&lang=js":
/*!********************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=script&lang=js ***!
  \********************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_FieldsSelect_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./FieldsSelect.vue?vue&type=script&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=script&lang=js");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_FieldsSelect_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=script&lang=js":
/*!*************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=script&lang=js ***!
  \*************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ObjectsDataSelect_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ObjectsDataSelect.vue?vue&type=script&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=script&lang=js");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ObjectsDataSelect_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=script&lang=js":
/*!**************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=script&lang=js ***!
  \**************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_Select_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Select.vue?vue&type=script&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=script&lang=js");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_Select_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/frontend/core/components/Calendar.vue?vue&type=template&id=2aad669c&scoped=true":
/*!***************************************************************************************************!*\
  !*** ./resources/frontend/core/components/Calendar.vue?vue&type=template&id=2aad669c&scoped=true ***!
  \***************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Calendar_vue_vue_type_template_id_2aad669c_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   staticRenderFns: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Calendar_vue_vue_type_template_id_2aad669c_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Calendar_vue_vue_type_template_id_2aad669c_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Calendar.vue?vue&type=template&id=2aad669c&scoped=true */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/Calendar.vue?vue&type=template&id=2aad669c&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/components/ExportDropdown.vue?vue&type=template&id=d02fc97a&scoped=true":
/*!*********************************************************************************************************!*\
  !*** ./resources/frontend/core/components/ExportDropdown.vue?vue&type=template&id=d02fc97a&scoped=true ***!
  \*********************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ExportDropdown_vue_vue_type_template_id_d02fc97a_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   staticRenderFns: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ExportDropdown_vue_vue_type_template_id_d02fc97a_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ExportDropdown_vue_vue_type_template_id_d02fc97a_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ExportDropdown.vue?vue&type=template&id=d02fc97a&scoped=true */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=template&id=d02fc97a&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=template&id=289c8081&scoped=true":
/*!*********************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=template&id=289c8081&scoped=true ***!
  \*********************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_EditUniversalReport_vue_vue_type_template_id_289c8081_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   staticRenderFns: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_EditUniversalReport_vue_vue_type_template_id_289c8081_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_EditUniversalReport_vue_vue_type_template_id_289c8081_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./EditUniversalReport.vue?vue&type=template&id=289c8081&scoped=true */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=template&id=289c8081&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=template&id=49e1298e&scoped=true":
/*!**************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=template&id=49e1298e&scoped=true ***!
  \**************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_FieldsSelect_vue_vue_type_template_id_49e1298e_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   staticRenderFns: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_FieldsSelect_vue_vue_type_template_id_49e1298e_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_FieldsSelect_vue_vue_type_template_id_49e1298e_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./FieldsSelect.vue?vue&type=template&id=49e1298e&scoped=true */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=template&id=49e1298e&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=template&id=2a42f486&scoped=true":
/*!*******************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=template&id=2a42f486&scoped=true ***!
  \*******************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ObjectsDataSelect_vue_vue_type_template_id_2a42f486_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   staticRenderFns: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ObjectsDataSelect_vue_vue_type_template_id_2a42f486_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ObjectsDataSelect_vue_vue_type_template_id_2a42f486_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ObjectsDataSelect.vue?vue&type=template&id=2a42f486&scoped=true */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=template&id=2a42f486&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=template&id=7ed046c0&scoped=true":
/*!********************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=template&id=7ed046c0&scoped=true ***!
  \********************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Select_vue_vue_type_template_id_7ed046c0_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   staticRenderFns: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Select_vue_vue_type_template_id_7ed046c0_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_Select_vue_vue_type_template_id_7ed046c0_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Select.vue?vue&type=template&id=7ed046c0&scoped=true */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=template&id=7ed046c0&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/components/Calendar.vue?vue&type=style&index=0&id=2aad669c&lang=scss&scoped=true":
/*!******************************************************************************************************************!*\
  !*** ./resources/frontend/core/components/Calendar.vue?vue&type=style&index=0&id=2aad669c&lang=scss&scoped=true ***!
  \******************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_clonedRuleSet_12_use_0_node_modules_laravel_mix_node_modules_css_loader_dist_cjs_js_clonedRuleSet_12_use_1_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_12_use_2_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_12_use_3_node_modules_sass_resources_loader_lib_loader_js_clonedRuleSet_12_use_4_node_modules_vue_loader_lib_index_js_vue_loader_options_Calendar_vue_vue_type_style_index_0_id_2aad669c_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!../../../../node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!../../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!../../../../node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Calendar.vue?vue&type=style&index=0&id=2aad669c&lang=scss&scoped=true */ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/Calendar.vue?vue&type=style&index=0&id=2aad669c&lang=scss&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/components/ExportDropdown.vue?vue&type=style&index=0&id=d02fc97a&lang=scss&scoped=true":
/*!************************************************************************************************************************!*\
  !*** ./resources/frontend/core/components/ExportDropdown.vue?vue&type=style&index=0&id=d02fc97a&lang=scss&scoped=true ***!
  \************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_clonedRuleSet_12_use_0_node_modules_laravel_mix_node_modules_css_loader_dist_cjs_js_clonedRuleSet_12_use_1_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_12_use_2_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_12_use_3_node_modules_sass_resources_loader_lib_loader_js_clonedRuleSet_12_use_4_node_modules_vue_loader_lib_index_js_vue_loader_options_ExportDropdown_vue_vue_type_style_index_0_id_d02fc97a_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!../../../../node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!../../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!../../../../node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ExportDropdown.vue?vue&type=style&index=0&id=d02fc97a&lang=scss&scoped=true */ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=style&index=0&id=d02fc97a&lang=scss&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=style&index=0&id=289c8081&lang=scss&scoped=true":
/*!************************************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=style&index=0&id=289c8081&lang=scss&scoped=true ***!
  \************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_clonedRuleSet_12_use_0_node_modules_laravel_mix_node_modules_css_loader_dist_cjs_js_clonedRuleSet_12_use_1_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_12_use_2_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_12_use_3_node_modules_sass_resources_loader_lib_loader_js_clonedRuleSet_12_use_4_node_modules_vue_loader_lib_index_js_vue_loader_options_EditUniversalReport_vue_vue_type_style_index_0_id_289c8081_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!../../../../../../node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!../../../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!../../../../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!../../../../../../node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./EditUniversalReport.vue?vue&type=style&index=0&id=289c8081&lang=scss&scoped=true */ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/EditUniversalReport.vue?vue&type=style&index=0&id=289c8081&lang=scss&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=style&index=0&id=49e1298e&lang=scss&scoped=true":
/*!*****************************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=style&index=0&id=49e1298e&lang=scss&scoped=true ***!
  \*****************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_clonedRuleSet_12_use_0_node_modules_laravel_mix_node_modules_css_loader_dist_cjs_js_clonedRuleSet_12_use_1_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_12_use_2_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_12_use_3_node_modules_sass_resources_loader_lib_loader_js_clonedRuleSet_12_use_4_node_modules_vue_loader_lib_index_js_vue_loader_options_FieldsSelect_vue_vue_type_style_index_0_id_49e1298e_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!../../../../../../node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!../../../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!../../../../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!../../../../../../node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./FieldsSelect.vue?vue&type=style&index=0&id=49e1298e&lang=scss&scoped=true */ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/FieldsSelect.vue?vue&type=style&index=0&id=49e1298e&lang=scss&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=style&index=0&id=2a42f486&lang=scss&scoped=true":
/*!**********************************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=style&index=0&id=2a42f486&lang=scss&scoped=true ***!
  \**********************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_clonedRuleSet_12_use_0_node_modules_laravel_mix_node_modules_css_loader_dist_cjs_js_clonedRuleSet_12_use_1_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_12_use_2_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_12_use_3_node_modules_sass_resources_loader_lib_loader_js_clonedRuleSet_12_use_4_node_modules_vue_loader_lib_index_js_vue_loader_options_ObjectsDataSelect_vue_vue_type_style_index_0_id_2a42f486_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!../../../../../../node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!../../../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!../../../../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!../../../../../../node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ObjectsDataSelect.vue?vue&type=style&index=0&id=2a42f486&lang=scss&scoped=true */ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/ObjectsDataSelect.vue?vue&type=style&index=0&id=2a42f486&lang=scss&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=style&index=0&id=7ed046c0&lang=scss&scoped=true":
/*!***********************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=style&index=0&id=7ed046c0&lang=scss&scoped=true ***!
  \***********************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_clonedRuleSet_12_use_0_node_modules_laravel_mix_node_modules_css_loader_dist_cjs_js_clonedRuleSet_12_use_1_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_12_use_2_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_12_use_3_node_modules_sass_resources_loader_lib_loader_js_clonedRuleSet_12_use_4_node_modules_vue_loader_lib_index_js_vue_loader_options_Select_vue_vue_type_style_index_0_id_7ed046c0_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!../../../../../../node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!../../../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!../../../../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!../../../../../../node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./Select.vue?vue&type=style&index=0&id=7ed046c0&lang=scss&scoped=true */ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/UniversalReport/views/Select.vue?vue&type=style&index=0&id=7ed046c0&lang=scss&scoped=true");


/***/ })

}]);