(self["webpackChunk_cattr_frontend_application"] = self["webpackChunk_cattr_frontend_application"] || []).push([["report.plannedtime"],{

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=script&lang=js":
/*!*******************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=script&lang=js ***!
  \*******************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _services_resource_about_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/services/resource/about.service */ "./resources/frontend/core/services/resource/about.service.js");

const aboutService = new _services_resource_about_service__WEBPACK_IMPORTED_MODULE_0__["default"]();
/* harmony default export */ __webpack_exports__["default"] = ({
  name: 'ExportDropdown',
  props: {
    position: {
      type: String,
      default: 'bottom-left'
    },
    trigger: {
      type: String,
      default: 'click'
    }
  },
  data: () => ({
    types: []
  }),
  async created() {
    this.types = await aboutService.getReportTypes();
  },
  methods: {
    onExport(format) {
      this.$emit('export', this.types[format]);
    },
    onClose() {
      this.$emit('close');
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/MultiSelect.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/MultiSelect.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _services_resource_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../services/resource.service */ "./resources/frontend/core/services/resource.service.js");

/* harmony default export */ __webpack_exports__["default"] = ({
  props: {
    service: {
      type: _services_resource_service__WEBPACK_IMPORTED_MODULE_0__["default"]
    },
    selected: {
      type: [String, Number, Array, Object],
      default: Array
    },
    inputHandler: {
      type: Function
    },
    prependName: {
      type: String,
      default: ''
    },
    showSelectAll: {
      type: Boolean,
      default: true
    },
    placeholder: {
      type: String,
      required: true
    },
    size: {
      type: String,
      default: 'normal'
    }
  },
  data() {
    return {
      model: [],
      showCount: true,
      options: []
    };
  },
  async created() {
    try {
      const all = await this.service.getAll({
        headers: {
          'X-Paginate': 'false'
        }
      });
      this.options.push(...all);
      this.$emit('onOptionsLoad', this.options);
    } catch ({
      response
    }) {
      if (true) {
        console.warn(response ? response : 'request to projects is canceled');
      }
    }
    if (Array.isArray(this.selected)) {
      this.model = this.selected;
    }
    this.$nextTick(() => {
      this.model.forEach(modelValue => {
        if (this.$refs.select && Object.prototype.hasOwnProperty.call(this.$refs.select, '$children')) {
          this.$refs.select.$children.forEach(option => {
            if (option.value === modelValue) {
              option.selected = true;
            }
          });
        }
      });
    });
    this.lastQuery = '';
    this.$watch(() => {
      if (this.$refs.select === undefined) {
        return;
      }
      return {
        query: this.$refs.select.query,
        visible: this.$refs.select.visible
      };
    }, ({
      query,
      visible
    }) => {
      if (visible) {
        if (query.length) {
          this.lastQuery = query;
        } else {
          if (['input', 'keypress'].includes(window?.event?.type) || window?.event?.key === 'Backspace') {
            // If query changed by user typing, save query
            this.lastQuery = query;
          } else {
            // If query changed by clicking option and so on, restore query
            this.$refs.select.query = this.lastQuery;
          }
        }
      } else {
        this.lastQuery = query;
      }
    });
  },
  watch: {
    model(value) {
      if (this.inputHandler) {
        this.inputHandler(value);
      }
    }
  },
  methods: {
    selectAll(predicate = () => true) {
      if (this.allOptionsSelected) {
        this.model = [];
      } else {
        // console.log(this.$refs.select);
        const query = this.$refs.select.query.toUpperCase();
        this.model = this.options.filter(({
          name
        }) => name.toUpperCase().indexOf(query) !== -1).filter(predicate).map(({
          id
        }) => id);
      }
    },
    clearSelect() {
      this.$emit('input', []);
      this.model = [];
    },
    onClick() {
      if (this.showCount) {
        this.showCount = false;
      } else {
        setTimeout(() => {
          this.showCount = true;
        }, 300);
      }
    },
    onClose() {
      this.$refs.select.query = '';
      if (!this.showCount) {
        setTimeout(() => {
          this.showCount = true;
        }, 300);
      }
    },
    onChange(val) {
      if (this.inputHandler) {
        this.inputHandler(val);
      }
    }
  },
  computed: {
    selectionAmount() {
      return this.model.length;
    },
    allOptionsSelected() {
      return this.options.length > 0 && this.options.length === this.selectionAmount;
    },
    placeholderText() {
      const i18nKey = this.placeholder + (this.allOptionsSelected ? '_all' : '');
      return this.$tc(i18nKey, this.selectionAmount, {
        count: this.selectionAmount
      });
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ProjectSelect.vue?vue&type=script&lang=js":
/*!******************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ProjectSelect.vue?vue&type=script&lang=js ***!
  \******************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _components_MultiSelect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/components/MultiSelect */ "./resources/frontend/core/components/MultiSelect.vue");
/* harmony import */ var _services_resource_project_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/services/resource/project.service */ "./resources/frontend/core/services/resource/project.service.js");


const localStorageKey = 'amazingcat.local.storage.project_select';
/* harmony default export */ __webpack_exports__["default"] = ({
  name: 'ProjectSelect',
  components: {
    MultiSelect: _components_MultiSelect__WEBPACK_IMPORTED_MODULE_0__["default"]
  },
  props: {
    size: {
      type: String,
      default: 'normal'
    },
    value: {
      type: Array,
      default: null
    }
  },
  data() {
    const selectedProjectIds = this.value !== null ? this.value : JSON.parse(localStorage.getItem(localStorageKey));
    return {
      projectService: new _services_resource_project_service__WEBPACK_IMPORTED_MODULE_1__["default"](),
      selectedProjectIds,
      ids: []
    };
  },
  methods: {
    onLoad(allSelectOptions) {
      const allProjectIds = allSelectOptions.map(option => option.id);
      this.ids = allProjectIds;
      // Select all options if storage is empty
      if (!localStorage.getItem(localStorageKey)) {
        this.selectedProjectIds = allProjectIds;
        localStorage.setItem(localStorageKey, JSON.stringify(this.selectedProjectIds));
        this.$emit('change', this.selectedProjectIds);
        this.$nextTick(() => this.$emit('loaded'));
        return;
      }

      // Remove options that no longer exists
      const existingProjectIds = this.selectedProjectIds.filter(projectId => allProjectIds.includes(projectId));
      if (this.selectedProjectIds.length > existingProjectIds.length) {
        this.selectedProjectIds = existingProjectIds;
        localStorage.setItem(localStorageKey, JSON.stringify(this.selectedProjectIds));
      }
      this.$emit('change', this.selectedProjectIds);
      this.$nextTick(() => this.$emit('loaded'));
    },
    selectedProjects(values) {
      this.selectedProjectIds = values;
      localStorage.setItem(localStorageKey, JSON.stringify(this.selectedProjectIds));
      this.$emit('change', values);
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=script&lang=js":
/*!*******************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=script&lang=js ***!
  \*******************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _service_planned_time_report__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../service/planned-time-report */ "./resources/frontend/core/modules/PlannedTimeReport/service/planned-time-report.js");
/* harmony import */ var _PlannedTimeReport_ProjectLine__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PlannedTimeReport/ProjectLine */ "./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue");
/* harmony import */ var _utils_time__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/utils/time */ "./resources/frontend/core/utils/time.js");
/* harmony import */ var _components_ProjectSelect__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/components/ProjectSelect */ "./resources/frontend/core/components/ProjectSelect.vue");
/* harmony import */ var _components_Preloader__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/components/Preloader */ "./resources/frontend/core/components/Preloader.vue");
/* harmony import */ var _components_ExportDropdown__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/components/ExportDropdown */ "./resources/frontend/core/components/ExportDropdown.vue");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var lodash_debounce__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash.debounce */ "./node_modules/lodash.debounce/index.js");
/* harmony import */ var lodash_debounce__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash_debounce__WEBPACK_IMPORTED_MODULE_6__);
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : String(i); }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }








const reportService = new _service_planned_time_report__WEBPACK_IMPORTED_MODULE_0__["default"]();
/* harmony default export */ __webpack_exports__["default"] = ({
  name: 'PlannedTimeReport',
  components: {
    ProjectLine: _PlannedTimeReport_ProjectLine__WEBPACK_IMPORTED_MODULE_1__["default"],
    ProjectSelect: _components_ProjectSelect__WEBPACK_IMPORTED_MODULE_3__["default"],
    Preloader: _components_Preloader__WEBPACK_IMPORTED_MODULE_4__["default"],
    ExportDropdown: _components_ExportDropdown__WEBPACK_IMPORTED_MODULE_5__["default"]
  },
  data() {
    return {
      isDataLoading: false,
      projects: [],
      reportDate: null,
      projectsList: [],
      projectReportsList: {},
      userIds: []
    };
  },
  computed: _objectSpread(_objectSpread({}, (0,vuex__WEBPACK_IMPORTED_MODULE_7__.mapGetters)('user', ['companyData'])), {}, {
    totalTime() {
      return (0,_utils_time__WEBPACK_IMPORTED_MODULE_2__.formatDurationString)(this.projects.reduce((acc, proj) => acc + proj.total_spent_time, 0));
    }
  }),
  methods: {
    onProjectsChange(projectIDs) {
      this.projectsList = projectIDs;
      this.fetchData();
    },
    fetchData: lodash_debounce__WEBPACK_IMPORTED_MODULE_6___default()(async function () {
      this.isDataLoading = true;
      try {
        const {
          data
        } = await reportService.getReport(this.projectsList);
        this.$set(this, 'projects', data.data.reportData);
        this.$set(this, 'reportDate', data.data.reportDate);
      } catch ({
        response
      }) {
        if (true) {
          console.warn(response ? response : 'request to projects is canceled');
        }
      }
      this.isDataLoading = false;
    }, 350),
    async onExport(format) {
      try {
        const {
          data
        } = await reportService.downloadReport(this.projectsList, format);
        window.open(data.data.url, '_blank');
      } catch ({
        response
      }) {
        if (true) {
          console.log(response ? response : 'request to reports is canceled');
        }
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=script&lang=js":
/*!*******************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=script&lang=js ***!
  \*******************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var moment_timezone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! moment-timezone */ "./node_modules/moment-timezone/index.js");
/* harmony import */ var moment_timezone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(moment_timezone__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_UserAvatar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/components/UserAvatar */ "./resources/frontend/core/components/UserAvatar.vue");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var _utils_time__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/utils/time */ "./resources/frontend/core/utils/time.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : String(i); }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }




/* harmony default export */ __webpack_exports__["default"] = ({
  name: 'ProjectLine',
  components: {
    UserAvatar: _components_UserAvatar__WEBPACK_IMPORTED_MODULE_1__["default"]
  },
  data() {
    return {
      openedDates: [],
      avatarSize: 35,
      screenshotsPerRow: 6,
      userTimezone: moment_timezone__WEBPACK_IMPORTED_MODULE_0___default().tz.guess()
    };
  },
  props: {
    project: {
      type: Object,
      required: true
    }
  },
  computed: _objectSpread({}, (0,vuex__WEBPACK_IMPORTED_MODULE_3__.mapGetters)('user', ['companyData'])),
  methods: {
    moment: (moment_timezone__WEBPACK_IMPORTED_MODULE_0___default()),
    formatDurationString: _utils_time__WEBPACK_IMPORTED_MODULE_2__.formatDurationString,
    formatDate(value) {
      return moment_timezone__WEBPACK_IMPORTED_MODULE_0___default()(value).format('DD.MM.YYYY HH:mm:ss');
    },
    getPercentage(seconds, totalTime) {
      if (!totalTime || !seconds) {
        return 0;
      }
      return (seconds * 100 / totalTime).toFixed(2);
    },
    getPercentageForProgress(seconds, totalTime) {
      const percent = this.getPercentage(seconds, totalTime);
      // 99.99% is used coz at-percent component will change status to success for 100%
      return percent >= 100 ? 99.99 : +percent;
    },
    isOverDue(companyTimezone, item) {
      return typeof companyTimezone === 'string' && item.due_date != null && moment_timezone__WEBPACK_IMPORTED_MODULE_0___default().utc(item.due_date).tz(companyTimezone, true).isBefore(moment_timezone__WEBPACK_IMPORTED_MODULE_0___default()());
    },
    isOverTime(item) {
      return item.estimate != null && item.total_spent_time > item.estimate;
    },
    getProgressStatus(item) {
      if (this.isOverTime(item) || this.isOverDue(this.companyData.timezone, item)) {
        return 'error';
      }
      return 'success';
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=template&id=d02fc97a&scoped=true":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=template&id=d02fc97a&scoped=true ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* binding */ render; },
/* harmony export */   staticRenderFns: function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', {
    staticClass: "dropdown"
  }, [_c('at-dropdown', {
    attrs: {
      "placement": _vm.position,
      "trigger": _vm.trigger
    },
    on: {
      "on-dropdown-command": _vm.onExport
    }
  }, [_c('at-button', {
    attrs: {
      "type": "text"
    }
  }, [_c('span', {
    staticClass: "icon icon-save"
  })]), _vm._v(" "), _c('at-dropdown-menu', {
    attrs: {
      "slot": "menu"
    },
    slot: "menu"
  }, _vm._l(_vm.types, function (type, key) {
    return _c('at-dropdown-item', {
      key: key,
      attrs: {
        "name": key
      }
    }, [_vm._v(_vm._s(key.toUpperCase()))]);
  }), 1)], 1)], 1);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/MultiSelect.vue?vue&type=template&id=017e6227&scoped=true":
/*!***************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/MultiSelect.vue?vue&type=template&id=017e6227&scoped=true ***!
  \***************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* binding */ render; },
/* harmony export */   staticRenderFns: function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', {
    staticClass: "at-select-wrapper"
  }, [_c('at-select', {
    ref: "select",
    attrs: {
      "multiple": "",
      "filterable": "",
      "placeholder": "",
      "size": _vm.size
    },
    on: {
      "click": _vm.onClick,
      "input": _vm.onChange
    },
    model: {
      value: _vm.model,
      callback: function ($$v) {
        _vm.model = $$v;
      },
      expression: "model"
    }
  }, [_vm.showSelectAll ? _c('li', {
    staticClass: "at-select__option",
    on: {
      "click": function ($event) {
        return _vm.selectAll();
      }
    }
  }, [_vm._v("\n            " + _vm._s(_vm.allOptionsSelected ? _vm.$t('control.deselect_all') : _vm.$t('control.select_all')) + "\n        ")]) : _vm._e(), _vm._v(" "), _vm._t("before-options"), _vm._v(" "), _vm._l(_vm.options, function (option) {
    return _c('at-option', {
      key: option.id,
      attrs: {
        "value": option.id,
        "label": option.name
      },
      on: {
        "on-select-close": _vm.onClose
      }
    });
  })], 2), _vm._v(" "), _vm.showCount ? _c('span', {
    staticClass: "at-select__placeholder"
  }, [_vm._v("\n        " + _vm._s(_vm.placeholderText) + "\n    ")]) : _vm._e(), _vm._v(" "), _vm.model.length > 0 ? _c('i', {
    staticClass: "icon icon-x at-select__clear",
    on: {
      "click": function ($event) {
        $event.stopPropagation();
        return _vm.clearSelect.apply(null, arguments);
      }
    }
  }) : _vm._e()], 1);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ProjectSelect.vue?vue&type=template&id=aaed6cf2":
/*!*****************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ProjectSelect.vue?vue&type=template&id=aaed6cf2 ***!
  \*****************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* binding */ render; },
/* harmony export */   staticRenderFns: function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('multi-select', {
    attrs: {
      "placeholder": "control.project_selected",
      "inputHandler": _vm.selectedProjects,
      "selected": _vm.selectedProjectIds,
      "service": _vm.projectService,
      "name": "projects",
      "size": _vm.size
    },
    on: {
      "onOptionsLoad": _vm.onLoad
    }
  });
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=template&id=e7456312&scoped=true":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=template&id=e7456312&scoped=true ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* binding */ render; },
/* harmony export */   staticRenderFns: function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', {
    staticClass: "project-reports"
  }, [_c('h1', {
    staticClass: "page-title"
  }, [_vm._v(_vm._s(_vm.$t('navigation.planned-time-report')))]), _vm._v(" "), _c('div', {
    staticClass: "controls-row"
  }, [_c('ProjectSelect', {
    staticClass: "controls-row__item",
    on: {
      "change": _vm.onProjectsChange
    }
  }), _vm._v(" "), _c('div', {
    staticClass: "controls-row__item controls-row__item--left-auto"
  }, [_vm.reportDate ? _c('small', [_vm._v("\n                " + _vm._s(_vm.$t('planned-time-report.report_date', [_vm.reportDate])) + "\n            ")]) : _vm._e()]), _vm._v(" "), _c('ExportDropdown', {
    staticClass: "export-btn dropdown controls-row__btn controls-row__item",
    attrs: {
      "position": "left-top",
      "trigger": "hover"
    },
    on: {
      "export": _vm.onExport
    }
  })], 1), _vm._v(" "), _c('div', {
    staticClass: "at-container"
  }, [_c('div', {
    staticClass: "total-time-row"
  }, [_c('span', {
    staticClass: "total-time-label"
  }, [_vm._v(_vm._s(_vm.$t('field.total_time')))]), _vm._v(" "), _c('span', {
    staticClass: "total-time-value"
  }, [_vm._v(_vm._s(_vm.totalTime))])]), _vm._v(" "), Object.keys(_vm.projects).length && !_vm.isDataLoading ? _c('div', _vm._l(_vm.projects, function (project) {
    return _c('ProjectLine', {
      key: project.id,
      attrs: {
        "project": project
      }
    });
  }), 1) : _c('div', {
    staticClass: "at-container__inner no-data"
  }, [_vm.isDataLoading ? _c('preloader') : _vm._e(), _vm._v(" "), _c('span', [_vm._v(_vm._s(_vm.$t('message.no_data')))])], 1)])]);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=template&id=6bcbf016&scoped=true":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=template&id=6bcbf016&scoped=true ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* binding */ render; },
/* harmony export */   staticRenderFns: function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', {
    staticClass: "project"
  }, [_c('div', {
    staticClass: "project__header"
  }, [_c('div', {
    staticClass: "row flex-between"
  }, [_c('h1', {
    staticClass: "project__title"
  }, [_vm._v(_vm._s(_vm.project.name))]), _vm._v(" "), _c('span', {
    staticClass: "h3"
  }, [_vm._v(_vm._s(_vm.formatDurationString(_vm.project.total_spent_time)))])]), _vm._v(" "), _c('div', {
    staticClass: "row"
  }, [_c('div', {
    staticClass: "col-12"
  }, [_c('span', {
    staticClass: "h3"
  }, [_vm._v(_vm._s(_vm.$t('planned-time-report.tasks')))])]), _vm._v(" "), _c('div', {
    staticClass: "col-4"
  }, [_c('span', {
    staticClass: "h3"
  }, [_vm._v(_vm._s(_vm.$t('planned-time-report.estimate')))])]), _vm._v(" "), _c('div', {
    staticClass: "col-4"
  }, [_c('span', {
    staticClass: "h3"
  }, [_vm._v(_vm._s(_vm.$t('planned-time-report.spent')))])]), _vm._v(" "), _c('div', {
    staticClass: "col-4"
  }, [_c('span', {
    staticClass: "h3"
  }, [_vm._v(_vm._s(_vm.$t('planned-time-report.productivity')))])])])]), _vm._v(" "), _c('at-collapse', {
    staticClass: "list__item",
    attrs: {
      "accordion": "",
      "simple": ""
    }
  }, _vm._l(_vm.project.tasks, function (task) {
    return _c('at-collapse-item', {
      key: task.id,
      staticClass: "task list__item",
      attrs: {
        "name": `${task.id}`
      }
    }, [_c('div', {
      staticClass: "row flex-middle",
      attrs: {
        "slot": "title"
      },
      slot: "title"
    }, [_c('div', {
      staticClass: "col-12"
    }, [_c('span', {
      staticClass: "h4"
    }, [_vm._v(_vm._s(task.task_name))]), _vm._v(" "), _c('div', {
      staticClass: "task__tags"
    }, [_vm.isOverDue(_vm.companyData.timezone, task) ? _c('at-tag', {
      attrs: {
        "color": "error"
      }
    }, [_vm._v(_vm._s(_vm.$t('tasks.due_date--overdue')) + "\n                        ")]) : _vm._e(), _vm._v(" "), _vm.isOverTime(task) ? _c('at-tag', {
      attrs: {
        "color": "warning"
      }
    }, [_vm._v(_vm._s(_vm.$t('tasks.estimate--overtime')) + "\n                        ")]) : _vm._e()], 1)]), _vm._v(" "), _c('div', {
      staticClass: "col-4"
    }, [task.estimate > 0 ? _c('span', {
      staticClass: "h4"
    }, [_vm._v(_vm._s(_vm.formatDurationString(task.estimate)))]) : _vm._e()]), _vm._v(" "), _c('div', {
      staticClass: "col-4"
    }, [_c('span', {
      staticClass: "h4"
    }, [_vm._v(_vm._s(_vm.formatDurationString(task.total_spent_time)))])]), _vm._v(" "), _c('div', {
      staticClass: "col-4 task__progress"
    }, [_c('at-progress', {
      staticClass: "flex flex-middle",
      attrs: {
        "percent": _vm.getPercentageForProgress(task.total_spent_time, task.estimate),
        "status": _vm.getProgressStatus(task),
        "stroke-width": 20
      }
    }), _vm._v(" "), _c('span', {
      staticClass: "task__progress-percent"
    }, [_vm._v(_vm._s(_vm.getPercentage(task.total_spent_time, task.estimate)) + "%")])], 1)]), _vm._v(" "), _c('div', {
      staticClass: "row workers"
    }, _vm._l(task.workers, function (worker) {
      return _c('div', {
        key: `${task.id}-${worker.id}`,
        staticClass: "col-24"
      }, [_c('div', {
        staticClass: "row",
        attrs: {
          "slot": "title"
        },
        slot: "title"
      }, [_c('div', {
        staticClass: "col-1"
      }, [_c('user-avatar', {
        attrs: {
          "size": _vm.avatarSize,
          "user": worker.user
        }
      })], 1), _vm._v(" "), _c('div', {
        staticClass: "col-15"
      }, [_c('span', {
        staticClass: "h5"
      }, [_vm._v(_vm._s(worker.user.full_name))])]), _vm._v(" "), _c('div', {
        staticClass: "col-4"
      }, [_c('span', {
        staticClass: "h4"
      }, [_vm._v(_vm._s(_vm.formatDurationString(worker.duration)))])]), _vm._v(" "), _c('div', {
        staticClass: "col-4"
      }, [_c('at-progress', {
        attrs: {
          "percent": _vm.getPercentageForProgress(worker.duration, task.total_spent_time),
          "stroke-width": 15,
          "status": "success"
        }
      })], 1)])]);
    }), 0)]);
  }), 1)], 1);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./resources/frontend/core/modules/PlannedTimeReport/service/planned-time-report.js":
/*!******************************************************************************************!*\
  !*** ./resources/frontend/core/modules/PlannedTimeReport/service/planned-time-report.js ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ PlannedTimeReport; }
/* harmony export */ });
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! axios */ "./node_modules/axios/lib/axios.js");
/* harmony import */ var _services_report_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/services/report.service */ "./resources/frontend/core/services/report.service.js");


class PlannedTimeReport extends _services_report_service__WEBPACK_IMPORTED_MODULE_0__["default"] {
  /**
   * @returns {Promise<AxiosResponse<T>>}
   * @param projects
   */
  getReport(projects) {
    return axios__WEBPACK_IMPORTED_MODULE_1__["default"].post('report/planned-time', {
      projects
    });
  }

  /**
   * @returns {Promise<AxiosResponse<T>>}
   * @param projects
   * @param format
   */
  downloadReport(projects, format) {
    return axios__WEBPACK_IMPORTED_MODULE_1__["default"].post(`report/planned-time/download`, {
      projects
    }, {
      headers: {
        Accept: format
      }
    });
  }
}

/***/ }),

/***/ "./resources/frontend/core/services/resource/about.service.js":
/*!********************************************************************!*\
  !*** ./resources/frontend/core/services/resource/about.service.js ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ AboutService; }
/* harmony export */ });
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! axios */ "./node_modules/axios/lib/axios.js");

class AboutService {
  async getGeneralInfo() {
    const result = await axios__WEBPACK_IMPORTED_MODULE_0__["default"].get('about');
    return result.data;
  }
  async getStorageInfo() {
    const result = await axios__WEBPACK_IMPORTED_MODULE_0__["default"].get('about/storage');
    return result.data.data;
  }
  startCleanup() {
    return axios__WEBPACK_IMPORTED_MODULE_0__["default"].post('about/storage');
  }
  async getReportTypes() {
    const result = await axios__WEBPACK_IMPORTED_MODULE_0__["default"].get('about/reports');
    return result.data.data.types;
  }
}

/***/ }),

/***/ "./node_modules/lodash.debounce/index.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash.debounce/index.js ***!
  \***********************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/**
 * lodash (Custom Build) <https://lodash.com/>
 * Build: `lodash modularize exports="npm" -o ./`
 * Copyright jQuery Foundation and other contributors <https://jquery.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */

/** Used as the `TypeError` message for "Functions" methods. */
var FUNC_ERROR_TEXT = 'Expected a function';

/** Used as references for various `Number` constants. */
var NAN = 0 / 0;

/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/** Used to match leading and trailing whitespace. */
var reTrim = /^\s+|\s+$/g;

/** Used to detect bad signed hexadecimal string values. */
var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

/** Used to detect binary string values. */
var reIsBinary = /^0b[01]+$/i;

/** Used to detect octal string values. */
var reIsOctal = /^0o[0-7]+$/i;

/** Built-in method references without a dependency on `root`. */
var freeParseInt = parseInt;

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof __webpack_require__.g == 'object' && __webpack_require__.g && __webpack_require__.g.Object === Object && __webpack_require__.g;

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var objectToString = objectProto.toString;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max,
    nativeMin = Math.min;

/**
 * Gets the timestamp of the number of milliseconds that have elapsed since
 * the Unix epoch (1 January 1970 00:00:00 UTC).
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Date
 * @returns {number} Returns the timestamp.
 * @example
 *
 * _.defer(function(stamp) {
 *   console.log(_.now() - stamp);
 * }, _.now());
 * // => Logs the number of milliseconds it took for the deferred invocation.
 */
var now = function() {
  return root.Date.now();
};

/**
 * Creates a debounced function that delays invoking `func` until after `wait`
 * milliseconds have elapsed since the last time the debounced function was
 * invoked. The debounced function comes with a `cancel` method to cancel
 * delayed `func` invocations and a `flush` method to immediately invoke them.
 * Provide `options` to indicate whether `func` should be invoked on the
 * leading and/or trailing edge of the `wait` timeout. The `func` is invoked
 * with the last arguments provided to the debounced function. Subsequent
 * calls to the debounced function return the result of the last `func`
 * invocation.
 *
 * **Note:** If `leading` and `trailing` options are `true`, `func` is
 * invoked on the trailing edge of the timeout only if the debounced function
 * is invoked more than once during the `wait` timeout.
 *
 * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
 * until to the next tick, similar to `setTimeout` with a timeout of `0`.
 *
 * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
 * for details over the differences between `_.debounce` and `_.throttle`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to debounce.
 * @param {number} [wait=0] The number of milliseconds to delay.
 * @param {Object} [options={}] The options object.
 * @param {boolean} [options.leading=false]
 *  Specify invoking on the leading edge of the timeout.
 * @param {number} [options.maxWait]
 *  The maximum time `func` is allowed to be delayed before it's invoked.
 * @param {boolean} [options.trailing=true]
 *  Specify invoking on the trailing edge of the timeout.
 * @returns {Function} Returns the new debounced function.
 * @example
 *
 * // Avoid costly calculations while the window size is in flux.
 * jQuery(window).on('resize', _.debounce(calculateLayout, 150));
 *
 * // Invoke `sendMail` when clicked, debouncing subsequent calls.
 * jQuery(element).on('click', _.debounce(sendMail, 300, {
 *   'leading': true,
 *   'trailing': false
 * }));
 *
 * // Ensure `batchLog` is invoked once after 1 second of debounced calls.
 * var debounced = _.debounce(batchLog, 250, { 'maxWait': 1000 });
 * var source = new EventSource('/stream');
 * jQuery(source).on('message', debounced);
 *
 * // Cancel the trailing debounced invocation.
 * jQuery(window).on('popstate', debounced.cancel);
 */
function debounce(func, wait, options) {
  var lastArgs,
      lastThis,
      maxWait,
      result,
      timerId,
      lastCallTime,
      lastInvokeTime = 0,
      leading = false,
      maxing = false,
      trailing = true;

  if (typeof func != 'function') {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  wait = toNumber(wait) || 0;
  if (isObject(options)) {
    leading = !!options.leading;
    maxing = 'maxWait' in options;
    maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
    trailing = 'trailing' in options ? !!options.trailing : trailing;
  }

  function invokeFunc(time) {
    var args = lastArgs,
        thisArg = lastThis;

    lastArgs = lastThis = undefined;
    lastInvokeTime = time;
    result = func.apply(thisArg, args);
    return result;
  }

  function leadingEdge(time) {
    // Reset any `maxWait` timer.
    lastInvokeTime = time;
    // Start the timer for the trailing edge.
    timerId = setTimeout(timerExpired, wait);
    // Invoke the leading edge.
    return leading ? invokeFunc(time) : result;
  }

  function remainingWait(time) {
    var timeSinceLastCall = time - lastCallTime,
        timeSinceLastInvoke = time - lastInvokeTime,
        result = wait - timeSinceLastCall;

    return maxing ? nativeMin(result, maxWait - timeSinceLastInvoke) : result;
  }

  function shouldInvoke(time) {
    var timeSinceLastCall = time - lastCallTime,
        timeSinceLastInvoke = time - lastInvokeTime;

    // Either this is the first call, activity has stopped and we're at the
    // trailing edge, the system time has gone backwards and we're treating
    // it as the trailing edge, or we've hit the `maxWait` limit.
    return (lastCallTime === undefined || (timeSinceLastCall >= wait) ||
      (timeSinceLastCall < 0) || (maxing && timeSinceLastInvoke >= maxWait));
  }

  function timerExpired() {
    var time = now();
    if (shouldInvoke(time)) {
      return trailingEdge(time);
    }
    // Restart the timer.
    timerId = setTimeout(timerExpired, remainingWait(time));
  }

  function trailingEdge(time) {
    timerId = undefined;

    // Only invoke if we have `lastArgs` which means `func` has been
    // debounced at least once.
    if (trailing && lastArgs) {
      return invokeFunc(time);
    }
    lastArgs = lastThis = undefined;
    return result;
  }

  function cancel() {
    if (timerId !== undefined) {
      clearTimeout(timerId);
    }
    lastInvokeTime = 0;
    lastArgs = lastCallTime = lastThis = timerId = undefined;
  }

  function flush() {
    return timerId === undefined ? result : trailingEdge(now());
  }

  function debounced() {
    var time = now(),
        isInvoking = shouldInvoke(time);

    lastArgs = arguments;
    lastThis = this;
    lastCallTime = time;

    if (isInvoking) {
      if (timerId === undefined) {
        return leadingEdge(lastCallTime);
      }
      if (maxing) {
        // Handle invocations in a tight loop.
        timerId = setTimeout(timerExpired, wait);
        return invokeFunc(lastCallTime);
      }
    }
    if (timerId === undefined) {
      timerId = setTimeout(timerExpired, wait);
    }
    return result;
  }
  debounced.cancel = cancel;
  debounced.flush = flush;
  return debounced;
}

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return !!value && (type == 'object' || type == 'function');
}

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return !!value && typeof value == 'object';
}

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && objectToString.call(value) == symbolTag);
}

/**
 * Converts `value` to a number.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {number} Returns the number.
 * @example
 *
 * _.toNumber(3.2);
 * // => 3.2
 *
 * _.toNumber(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toNumber(Infinity);
 * // => Infinity
 *
 * _.toNumber('3.2');
 * // => 3.2
 */
function toNumber(value) {
  if (typeof value == 'number') {
    return value;
  }
  if (isSymbol(value)) {
    return NAN;
  }
  if (isObject(value)) {
    var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
    value = isObject(other) ? (other + '') : other;
  }
  if (typeof value != 'string') {
    return value === 0 ? value : +value;
  }
  value = value.replace(reTrim, '');
  var isBinary = reIsBinary.test(value);
  return (isBinary || reIsOctal.test(value))
    ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
    : (reIsBadHex.test(value) ? NAN : +value);
}

module.exports = debounce;


/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=style&index=0&id=d02fc97a&lang=scss&scoped=true":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=style&index=0&id=d02fc97a&lang=scss&scoped=true ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/MultiSelect.vue?vue&type=style&index=0&id=017e6227&lang=scss&scoped=true":
/*!*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/MultiSelect.vue?vue&type=style&index=0&id=017e6227&lang=scss&scoped=true ***!
  \*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=style&index=0&id=e7456312&lang=scss&scoped=true":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=style&index=0&id=e7456312&lang=scss&scoped=true ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=style&index=0&id=6bcbf016&lang=scss&scoped=true":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=style&index=0&id=6bcbf016&lang=scss&scoped=true ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./resources/frontend/core/components/ExportDropdown.vue":
/*!***************************************************************!*\
  !*** ./resources/frontend/core/components/ExportDropdown.vue ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _ExportDropdown_vue_vue_type_template_id_d02fc97a_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ExportDropdown.vue?vue&type=template&id=d02fc97a&scoped=true */ "./resources/frontend/core/components/ExportDropdown.vue?vue&type=template&id=d02fc97a&scoped=true");
/* harmony import */ var _ExportDropdown_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ExportDropdown.vue?vue&type=script&lang=js */ "./resources/frontend/core/components/ExportDropdown.vue?vue&type=script&lang=js");
/* harmony import */ var _ExportDropdown_vue_vue_type_style_index_0_id_d02fc97a_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ExportDropdown.vue?vue&type=style&index=0&id=d02fc97a&lang=scss&scoped=true */ "./resources/frontend/core/components/ExportDropdown.vue?vue&type=style&index=0&id=d02fc97a&lang=scss&scoped=true");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _ExportDropdown_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _ExportDropdown_vue_vue_type_template_id_d02fc97a_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render,
  _ExportDropdown_vue_vue_type_template_id_d02fc97a_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "d02fc97a",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/frontend/core/components/ExportDropdown.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/frontend/core/components/MultiSelect.vue":
/*!************************************************************!*\
  !*** ./resources/frontend/core/components/MultiSelect.vue ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _MultiSelect_vue_vue_type_template_id_017e6227_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MultiSelect.vue?vue&type=template&id=017e6227&scoped=true */ "./resources/frontend/core/components/MultiSelect.vue?vue&type=template&id=017e6227&scoped=true");
/* harmony import */ var _MultiSelect_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MultiSelect.vue?vue&type=script&lang=js */ "./resources/frontend/core/components/MultiSelect.vue?vue&type=script&lang=js");
/* harmony import */ var _MultiSelect_vue_vue_type_style_index_0_id_017e6227_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MultiSelect.vue?vue&type=style&index=0&id=017e6227&lang=scss&scoped=true */ "./resources/frontend/core/components/MultiSelect.vue?vue&type=style&index=0&id=017e6227&lang=scss&scoped=true");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _MultiSelect_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _MultiSelect_vue_vue_type_template_id_017e6227_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render,
  _MultiSelect_vue_vue_type_template_id_017e6227_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "017e6227",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/frontend/core/components/MultiSelect.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/frontend/core/components/ProjectSelect.vue":
/*!**************************************************************!*\
  !*** ./resources/frontend/core/components/ProjectSelect.vue ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _ProjectSelect_vue_vue_type_template_id_aaed6cf2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ProjectSelect.vue?vue&type=template&id=aaed6cf2 */ "./resources/frontend/core/components/ProjectSelect.vue?vue&type=template&id=aaed6cf2");
/* harmony import */ var _ProjectSelect_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ProjectSelect.vue?vue&type=script&lang=js */ "./resources/frontend/core/components/ProjectSelect.vue?vue&type=script&lang=js");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");





/* normalize component */
;
var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(
  _ProjectSelect_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _ProjectSelect_vue_vue_type_template_id_aaed6cf2__WEBPACK_IMPORTED_MODULE_0__.render,
  _ProjectSelect_vue_vue_type_template_id_aaed6cf2__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/frontend/core/components/ProjectSelect.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue":
/*!***************************************************************************************!*\
  !*** ./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _PlannedTimeReport_vue_vue_type_template_id_e7456312_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PlannedTimeReport.vue?vue&type=template&id=e7456312&scoped=true */ "./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=template&id=e7456312&scoped=true");
/* harmony import */ var _PlannedTimeReport_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PlannedTimeReport.vue?vue&type=script&lang=js */ "./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=script&lang=js");
/* harmony import */ var _PlannedTimeReport_vue_vue_type_style_index_0_id_e7456312_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./PlannedTimeReport.vue?vue&type=style&index=0&id=e7456312&lang=scss&scoped=true */ "./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=style&index=0&id=e7456312&lang=scss&scoped=true");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _PlannedTimeReport_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _PlannedTimeReport_vue_vue_type_template_id_e7456312_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render,
  _PlannedTimeReport_vue_vue_type_template_id_e7456312_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "e7456312",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue":
/*!***************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue ***!
  \***************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _ProjectLine_vue_vue_type_template_id_6bcbf016_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ProjectLine.vue?vue&type=template&id=6bcbf016&scoped=true */ "./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=template&id=6bcbf016&scoped=true");
/* harmony import */ var _ProjectLine_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ProjectLine.vue?vue&type=script&lang=js */ "./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=script&lang=js");
/* harmony import */ var _ProjectLine_vue_vue_type_style_index_0_id_6bcbf016_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ProjectLine.vue?vue&type=style&index=0&id=6bcbf016&lang=scss&scoped=true */ "./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=style&index=0&id=6bcbf016&lang=scss&scoped=true");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _ProjectLine_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _ProjectLine_vue_vue_type_template_id_6bcbf016_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render,
  _ProjectLine_vue_vue_type_template_id_6bcbf016_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "6bcbf016",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/frontend/core/components/ExportDropdown.vue?vue&type=script&lang=js":
/*!***************************************************************************************!*\
  !*** ./resources/frontend/core/components/ExportDropdown.vue?vue&type=script&lang=js ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ExportDropdown_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ExportDropdown.vue?vue&type=script&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=script&lang=js");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ExportDropdown_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/frontend/core/components/MultiSelect.vue?vue&type=script&lang=js":
/*!************************************************************************************!*\
  !*** ./resources/frontend/core/components/MultiSelect.vue?vue&type=script&lang=js ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_MultiSelect_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./MultiSelect.vue?vue&type=script&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/MultiSelect.vue?vue&type=script&lang=js");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_MultiSelect_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/frontend/core/components/ProjectSelect.vue?vue&type=script&lang=js":
/*!**************************************************************************************!*\
  !*** ./resources/frontend/core/components/ProjectSelect.vue?vue&type=script&lang=js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ProjectSelect_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ProjectSelect.vue?vue&type=script&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ProjectSelect.vue?vue&type=script&lang=js");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ProjectSelect_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=script&lang=js":
/*!***************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=script&lang=js ***!
  \***************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_PlannedTimeReport_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./PlannedTimeReport.vue?vue&type=script&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=script&lang=js");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_PlannedTimeReport_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=script&lang=js":
/*!***************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=script&lang=js ***!
  \***************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ProjectLine_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ProjectLine.vue?vue&type=script&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=script&lang=js");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ProjectLine_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/frontend/core/components/ExportDropdown.vue?vue&type=template&id=d02fc97a&scoped=true":
/*!*********************************************************************************************************!*\
  !*** ./resources/frontend/core/components/ExportDropdown.vue?vue&type=template&id=d02fc97a&scoped=true ***!
  \*********************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ExportDropdown_vue_vue_type_template_id_d02fc97a_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   staticRenderFns: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ExportDropdown_vue_vue_type_template_id_d02fc97a_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ExportDropdown_vue_vue_type_template_id_d02fc97a_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ExportDropdown.vue?vue&type=template&id=d02fc97a&scoped=true */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=template&id=d02fc97a&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/components/MultiSelect.vue?vue&type=template&id=017e6227&scoped=true":
/*!******************************************************************************************************!*\
  !*** ./resources/frontend/core/components/MultiSelect.vue?vue&type=template&id=017e6227&scoped=true ***!
  \******************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_MultiSelect_vue_vue_type_template_id_017e6227_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   staticRenderFns: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_MultiSelect_vue_vue_type_template_id_017e6227_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_MultiSelect_vue_vue_type_template_id_017e6227_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./MultiSelect.vue?vue&type=template&id=017e6227&scoped=true */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/MultiSelect.vue?vue&type=template&id=017e6227&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/components/ProjectSelect.vue?vue&type=template&id=aaed6cf2":
/*!********************************************************************************************!*\
  !*** ./resources/frontend/core/components/ProjectSelect.vue?vue&type=template&id=aaed6cf2 ***!
  \********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ProjectSelect_vue_vue_type_template_id_aaed6cf2__WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   staticRenderFns: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ProjectSelect_vue_vue_type_template_id_aaed6cf2__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ProjectSelect_vue_vue_type_template_id_aaed6cf2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ProjectSelect.vue?vue&type=template&id=aaed6cf2 */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ProjectSelect.vue?vue&type=template&id=aaed6cf2");


/***/ }),

/***/ "./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=template&id=e7456312&scoped=true":
/*!*********************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=template&id=e7456312&scoped=true ***!
  \*********************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_PlannedTimeReport_vue_vue_type_template_id_e7456312_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   staticRenderFns: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_PlannedTimeReport_vue_vue_type_template_id_e7456312_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_PlannedTimeReport_vue_vue_type_template_id_e7456312_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./PlannedTimeReport.vue?vue&type=template&id=e7456312&scoped=true */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=template&id=e7456312&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=template&id=6bcbf016&scoped=true":
/*!*********************************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=template&id=6bcbf016&scoped=true ***!
  \*********************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ProjectLine_vue_vue_type_template_id_6bcbf016_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   staticRenderFns: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ProjectLine_vue_vue_type_template_id_6bcbf016_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ProjectLine_vue_vue_type_template_id_6bcbf016_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ProjectLine.vue?vue&type=template&id=6bcbf016&scoped=true */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=template&id=6bcbf016&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/components/ExportDropdown.vue?vue&type=style&index=0&id=d02fc97a&lang=scss&scoped=true":
/*!************************************************************************************************************************!*\
  !*** ./resources/frontend/core/components/ExportDropdown.vue?vue&type=style&index=0&id=d02fc97a&lang=scss&scoped=true ***!
  \************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_clonedRuleSet_12_use_0_node_modules_laravel_mix_node_modules_css_loader_dist_cjs_js_clonedRuleSet_12_use_1_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_12_use_2_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_12_use_3_node_modules_sass_resources_loader_lib_loader_js_clonedRuleSet_12_use_4_node_modules_vue_loader_lib_index_js_vue_loader_options_ExportDropdown_vue_vue_type_style_index_0_id_d02fc97a_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!../../../../node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!../../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!../../../../node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ExportDropdown.vue?vue&type=style&index=0&id=d02fc97a&lang=scss&scoped=true */ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/ExportDropdown.vue?vue&type=style&index=0&id=d02fc97a&lang=scss&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/components/MultiSelect.vue?vue&type=style&index=0&id=017e6227&lang=scss&scoped=true":
/*!*********************************************************************************************************************!*\
  !*** ./resources/frontend/core/components/MultiSelect.vue?vue&type=style&index=0&id=017e6227&lang=scss&scoped=true ***!
  \*********************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_clonedRuleSet_12_use_0_node_modules_laravel_mix_node_modules_css_loader_dist_cjs_js_clonedRuleSet_12_use_1_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_12_use_2_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_12_use_3_node_modules_sass_resources_loader_lib_loader_js_clonedRuleSet_12_use_4_node_modules_vue_loader_lib_index_js_vue_loader_options_MultiSelect_vue_vue_type_style_index_0_id_017e6227_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!../../../../node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!../../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!../../../../node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./MultiSelect.vue?vue&type=style&index=0&id=017e6227&lang=scss&scoped=true */ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/components/MultiSelect.vue?vue&type=style&index=0&id=017e6227&lang=scss&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=style&index=0&id=e7456312&lang=scss&scoped=true":
/*!************************************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=style&index=0&id=e7456312&lang=scss&scoped=true ***!
  \************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_clonedRuleSet_12_use_0_node_modules_laravel_mix_node_modules_css_loader_dist_cjs_js_clonedRuleSet_12_use_1_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_12_use_2_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_12_use_3_node_modules_sass_resources_loader_lib_loader_js_clonedRuleSet_12_use_4_node_modules_vue_loader_lib_index_js_vue_loader_options_PlannedTimeReport_vue_vue_type_style_index_0_id_e7456312_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!../../../../../../node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!../../../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!../../../../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!../../../../../../node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./PlannedTimeReport.vue?vue&type=style&index=0&id=e7456312&lang=scss&scoped=true */ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport.vue?vue&type=style&index=0&id=e7456312&lang=scss&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=style&index=0&id=6bcbf016&lang=scss&scoped=true":
/*!************************************************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=style&index=0&id=6bcbf016&lang=scss&scoped=true ***!
  \************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_clonedRuleSet_12_use_0_node_modules_laravel_mix_node_modules_css_loader_dist_cjs_js_clonedRuleSet_12_use_1_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_12_use_2_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_12_use_3_node_modules_sass_resources_loader_lib_loader_js_clonedRuleSet_12_use_4_node_modules_vue_loader_lib_index_js_vue_loader_options_ProjectLine_vue_vue_type_style_index_0_id_6bcbf016_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../../node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!../../../../../../../node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!../../../../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!../../../../../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!../../../../../../../node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!../../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ProjectLine.vue?vue&type=style&index=0&id=6bcbf016&lang=scss&scoped=true */ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/PlannedTimeReport/views/PlannedTimeReport/ProjectLine.vue?vue&type=style&index=0&id=6bcbf016&lang=scss&scoped=true");


/***/ })

}]);