(self["webpackChunk_cattr_frontend_application"] = self["webpackChunk_cattr_frontend_application"] || []).push([["project-groups"],{

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=script&lang=js":
/*!*******************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=script&lang=js ***!
  \*******************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _components_GroupProjects__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../components/GroupProjects */ "./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue");

/* harmony default export */ __webpack_exports__["default"] = ({
  name: 'GroupCollapsable',
  components: {
    GroupProjects: _components_GroupProjects__WEBPACK_IMPORTED_MODULE_0__["default"]
  },
  data() {
    return {
      opened: []
    };
  },
  props: {
    groups: {
      type: Array,
      required: true
    }
  },
  methods: {
    isOpen(index) {
      return this.opened[0] === String(index);
    },
    reloadData() {
      this.$emit('reloadData');
    }
  },
  filters: {
    getSpaceByDepth(value) {
      return ''.padStart(value, '-');
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _services_resource_project_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/services/resource/project.service */ "./resources/frontend/core/services/resource/project.service.js");
/* harmony import */ var _components_TeamAvatars__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/components/TeamAvatars */ "./resources/frontend/core/components/TeamAvatars.vue");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/i18n */ "./resources/frontend/core/i18n/index.js");
/* harmony import */ var lodash_debounce__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash.debounce */ "./node_modules/lodash.debounce/index.js");
/* harmony import */ var lodash_debounce__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_debounce__WEBPACK_IMPORTED_MODULE_3__);




const service = new _services_resource_project_service__WEBPACK_IMPORTED_MODULE_0__["default"]();
/* harmony default export */ __webpack_exports__["default"] = ({
  name: 'GroupProjects',
  props: {
    groupId: {
      type: Number,
      required: true
    }
  },
  data() {
    return {
      projects: [],
      projectsTotal: 0,
      limit: 15,
      query: '',
      page: 1
    };
  },
  async created() {
    this.search = lodash_debounce__WEBPACK_IMPORTED_MODULE_3___default()(this.search, 350);
    await this.search();
  },
  methods: {
    async loadPage(page) {
      this.page = page;
      this.resetOptions();
      await this.loadOptions();
    },
    onSearch() {
      this.search();
    },
    async search() {
      this.totalPages = 0;
      this.resetOptions();
      await this.$nextTick();
      await this.loadOptions();
      await this.$nextTick();
    },
    async loadOptions() {
      const filters = {
        where: {
          group: ['in', [this.groupId]]
        },
        with: ['users', 'tasks', 'can'],
        withCount: ['tasks'],
        search: {
          query: this.query,
          fields: ['name']
        },
        page: this.page
      };
      return service.getWithFilters(filters).then(({
        data,
        pagination = data.pagination
      }) => {
        this.projectsTotal = pagination.total;
        this.currentPage = pagination.currentPage;
        data.data.forEach(option => this.projects.push(option));
      });
    },
    resetOptions() {
      this.projects = [];
    }
  },
  computed: {
    columns() {
      const columns = [{
        title: this.$t('field.project'),
        key: 'name'
      }, {
        title: this.$t('field.members'),
        key: 'users',
        render: (h, {
          item
        }) => {
          return h(_components_TeamAvatars__WEBPACK_IMPORTED_MODULE_1__["default"], {
            props: {
              users: item.users || []
            }
          });
        }
      }, {
        title: this.$t('field.amount_of_tasks'),
        key: 'tasks',
        render: (h, {
          item
        }) => {
          const amountOfTasks = item.tasks_count || 0;
          return h('span', _i18n__WEBPACK_IMPORTED_MODULE_2__["default"].tc('projects.amount_of_tasks', amountOfTasks, {
            count: amountOfTasks
          }));
        }
      }];
      const actions = [{
        title: 'control.view',
        icon: 'icon-eye',
        onClick: (router, {
          item
        }) => {
          this.$router.push({
            name: 'Projects.crud.projects.view',
            params: {
              id: item.id
            }
          });
        },
        renderCondition({
          $store
        }) {
          return true;
        }
      }, {
        title: 'projects.members',
        icon: 'icon-users',
        onClick: (router, {
          item
        }) => {
          this.$router.push({
            name: 'Projects.members',
            params: {
              id: item.id
            }
          });
        },
        renderCondition({
          $can
        }, item) {
          return $can('updateMembers', 'project', item);
        }
      }, {
        title: 'control.edit',
        icon: 'icon-edit',
        onClick: (router, {
          item
        }, context) => {
          this.$router.push({
            name: 'Projects.crud.projects.edit',
            params: {
              id: item.id
            }
          });
        },
        renderCondition: ({
          $can
        }, item) => {
          return $can('update', 'project', item);
        }
      }, {
        title: 'control.delete',
        actionType: 'error',
        // AT-UI action type,
        icon: 'icon-trash-2',
        onClick: async (router, {
          item
        }, context) => {
          const isConfirm = await this.$CustomModal({
            title: this.$t('notification.record.delete.confirmation.title'),
            content: this.$t('notification.record.delete.confirmation.message'),
            okText: this.$t('control.delete'),
            cancelText: this.$t('control.cancel'),
            showClose: false,
            styles: {
              'border-radius': '10px',
              'text-align': 'center',
              footer: {
                'text-align': 'center'
              },
              header: {
                padding: '16px 35px 4px 35px',
                color: 'red'
              },
              body: {
                padding: '16px 35px 4px 35px'
              }
            },
            width: 320,
            type: 'trash',
            typeButton: 'error'
          });
          if (isConfirm !== 'confirm') {
            return;
          }
          await service.deleteItem(item.id);
          this.$Notify({
            type: 'success',
            title: this.$t('notification.record.delete.success.title'),
            message: this.$t('notification.record.delete.success.message')
          });
          await this.search();
          this.$emit('reloadData');
        },
        renderCondition: ({
          $can
        }, item) => {
          return $can('delete', 'project', item);
        }
      }];
      columns.push({
        title: this.$t('field.actions'),
        render: (h, params) => {
          let cell = h('div', {
            class: 'actions-column'
          }, actions.map(item => {
            if (typeof item.renderCondition !== 'undefined' ? item.renderCondition(this, params.item) : true) {
              return h('AtButton', {
                props: {
                  type: item.actionType || 'primary',
                  // AT-ui button display type
                  icon: item.icon || undefined // Prepend icon to button
                },
                on: {
                  click: () => {
                    item.onClick(this.$router, params, this);
                  }
                },
                class: 'action-button',
                style: {
                  margin: '0 10px 0 0'
                }
              }, this.$t(item.title));
            }
          }));
          return cell;
        }
      });
      return columns;
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _services_resource_project_groups_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/services/resource/project-groups.service */ "./resources/frontend/core/services/resource/project-groups.service.js");
/* harmony import */ var _components_GroupCollapsable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../components/GroupCollapsable */ "./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue");
/* harmony import */ var _components_Preloader__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/components/Preloader */ "./resources/frontend/core/components/Preloader.vue");
/* harmony import */ var lodash_debounce__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash.debounce */ "./node_modules/lodash.debounce/index.js");
/* harmony import */ var lodash_debounce__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_debounce__WEBPACK_IMPORTED_MODULE_3__);




const service = new _services_resource_project_groups_service__WEBPACK_IMPORTED_MODULE_0__["default"]();
/* harmony default export */ __webpack_exports__["default"] = ({
  name: 'ProjectGroups',
  components: {
    Preloader: _components_Preloader__WEBPACK_IMPORTED_MODULE_2__["default"],
    GroupCollapsable: _components_GroupCollapsable__WEBPACK_IMPORTED_MODULE_1__["default"]
  },
  data() {
    return {
      groups: [],
      isDataLoading: false,
      groupsTotal: 0,
      limit: 10,
      totalPages: 0,
      currentPage: 0,
      query: '',
      isGroupSelected: false
    };
  },
  async created() {
    this.search = lodash_debounce__WEBPACK_IMPORTED_MODULE_3___default()(this.search, 350);
    this.requestTimestamp = Date.now();
    this.search(this.requestTimestamp);
  },
  mounted() {
    this.observer = new IntersectionObserver(this.infiniteScroll);
  },
  computed: {
    hasNextPage() {
      return this.currentPage < this.totalPages;
    }
  },
  methods: {
    async infiniteScroll([{
      isIntersecting,
      target
    }]) {
      if (isIntersecting) {
        const requestTimestamp = +target.dataset.requestTimestamp;
        if (requestTimestamp === this.requestTimestamp) {
          await this.loadOptions(requestTimestamp);
          await this.$nextTick();
          this.observer.disconnect();
          this.observe(requestTimestamp);
        }
      }
    },
    onSearch() {
      this.isGroupSelected = false;
      this.requestTimestamp = Date.now();
      this.search(this.requestTimestamp);
    },
    async search(requestTimestamp) {
      this.observer.disconnect();
      this.totalPages = 0;
      this.currentPage = 0;
      this.resetOptions();
      await this.$nextTick();
      await this.loadOptions(requestTimestamp);
      await this.$nextTick();
      this.observe(requestTimestamp);
    },
    observe(requestTimestamp) {
      if (this.$refs.load) {
        this.$refs.load.dataset.requestTimestamp = requestTimestamp;
        this.observer.observe(this.$refs.load);
      }
    },
    async loadOptions() {
      const filters = {
        search: {
          query: this.query,
          fields: ['name']
        },
        with: [],
        page: this.currentPage + 1,
        limit: this.limit
      };
      if (this.query !== '') {
        filters.with.push('groupParentsWithProjectsCount');
      }
      return service.getWithFilters(filters).then(({
        data,
        pagination
      }) => {
        this.groupsTotal = pagination.total;
        if (this.query === '') {
          this.totalPages = pagination.totalPages;
          this.currentPage = pagination.currentPage;
          data.forEach(option => this.groups.push(option));
        } else {
          this.totalPages = pagination.totalPages;
          this.currentPage = pagination.currentPage;
          data.forEach(option => {
            let breadCrumbs = [];
            option.group_parents_with_projects_count.forEach(el => {
              breadCrumbs.push({
                name: `${el.name} (${el.projects_count})`,
                id: el.id
              });
            });
            option.breadCrumbs = breadCrumbs;
            this.groups.push(option);
          });
        }
      });
    },
    resetOptions() {
      this.groups = [];
    },
    getTargetClickGroupAndChildren(id) {
      this.query = '';
      service.getWithFilters({
        where: {
          id
        },
        with: ['descendantsWithDepthAndProjectsCount']
      }).then(({
        data,
        pagination
      }) => {
        this.totalPages = pagination.totalPages;
        this.currentPage = pagination.currentPage;
        this.resetOptions();
        this.groups.push(data[0]);
        data[0].descendants_with_depth_and_projects_count.forEach(element => {
          this.groups.push(element);
        });
        this.isGroupSelected = true;
      });
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=template&id=fd8f5072&scoped=true":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=template&id=fd8f5072&scoped=true ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* binding */ render; },
/* harmony export */   staticRenderFns: function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', {
    staticClass: "groups"
  }, [_c('at-collapse', {
    attrs: {
      "simple": "",
      "accordion": ""
    },
    on: {
      "on-change": event => _vm.opened = event
    }
  }, _vm._l(_vm.groups, function (group, index) {
    return _c('at-collapse-item', {
      key: index,
      attrs: {
        "name": String(index),
        "disabled": group.projects_count === 0
      }
    }, [_c('div', {
      attrs: {
        "slot": "title"
      },
      slot: "title"
    }, [_c('div', {
      staticClass: "groups__header"
    }, [_c('h5', {
      staticClass: "groups__title",
      class: {
        groups__disabled: group.projects_count === 0
      }
    }, [group.depth > 0 && group.breadCrumbs == null ? _c('span', {
      staticClass: "groups__depth",
      class: {
        groups__disabled: group.projects_count === 0
      }
    }, [_vm._v("\n                            " + _vm._s(_vm._f("getSpaceByDepth")(group.depth)) + "\n                        ")]) : _vm._e(), _vm._v(" "), group.breadCrumbs ? _c('span', {
      staticClass: "groups__bread-crumbs"
    }, _vm._l(group.breadCrumbs, function (breadCrumb, index) {
      return _c('span', {
        key: index,
        staticClass: "groups__bread-crumbs__item",
        on: {
          "click": function ($event) {
            $event.stopPropagation();
            return _vm.$emit('getTargetClickGroupAndChildren', breadCrumb.id);
          }
        }
      }, [_vm._v("\n                                " + _vm._s(breadCrumb.name) + " /\n                            ")]);
    }), 0) : _vm._e(), _vm._v(" "), _c('span', [_vm._v(_vm._s(`${group.name} (${group.projects_count})`))])]), _vm._v(" "), _c('span', {
      on: {
        "click": function ($event) {
          $event.stopPropagation();
        }
      }
    }, [_vm.$can('update', 'projectGroup') ? _c('router-link', {
      staticClass: "groups__header__link",
      attrs: {
        "to": {
          name: 'ProjectGroups.crud.groups.edit',
          params: {
            id: group.id
          }
        },
        "target": "_blank",
        "rel": "opener"
      }
    }, [_c('i', {
      staticClass: "icon icon-external-link"
    })]) : _vm._e()], 1)])]), _vm._v(" "), group.projects_count > 0 && _vm.isOpen(index) ? _c('div', {
      staticClass: "groups__projects-wrapper"
    }, [_c('GroupProjects', {
      staticClass: "groups__projects",
      attrs: {
        "group-id": group.id
      },
      on: {
        "reloadData": function ($event) {
          return _vm.$emit('reloadData');
        }
      }
    })], 1) : _vm._e()]);
  }), 1)], 1);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=template&id=2f82abd6&scoped=true":
/*!***************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=template&id=2f82abd6&scoped=true ***!
  \***************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* binding */ render; },
/* harmony export */   staticRenderFns: function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', {
    staticClass: "projects"
  }, [_c('at-input', {
    staticClass: "projects__search col-6",
    attrs: {
      "type": "text",
      "placeholder": _vm.$t('message.project_search_input_placeholder')
    },
    on: {
      "input": _vm.onSearch
    },
    scopedSlots: _vm._u([{
      key: "prepend",
      fn: function () {
        return [_c('i', {
          staticClass: "icon icon-search"
        })];
      },
      proxy: true
    }]),
    model: {
      value: _vm.query,
      callback: function ($$v) {
        _vm.query = $$v;
      },
      expression: "query"
    }
  }), _vm._v(" "), _c('div', {
    staticClass: "at-container"
  }, [_c('div', {
    ref: "tableWrapper",
    staticClass: "table"
  }, [_c('at-table', {
    ref: "table",
    attrs: {
      "size": "large",
      "columns": _vm.columns,
      "data": _vm.projects
    }
  })], 1)]), _vm._v(" "), _c('at-pagination', {
    attrs: {
      "total": _vm.projectsTotal,
      "current": _vm.page,
      "page-size": _vm.limit
    },
    on: {
      "page-change": _vm.loadPage
    }
  })], 1);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=template&id=e17ffff2&scoped=true":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=template&id=e17ffff2&scoped=true ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* binding */ render; },
/* harmony export */   staticRenderFns: function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', {
    staticClass: "project-groups"
  }, [_c('h1', {
    staticClass: "page-title"
  }, [_vm._v(_vm._s(_vm.$t('groups.grid-title')))]), _vm._v(" "), _c('div', {
    staticClass: "project-groups__search-container"
  }, [_c('at-input', {
    staticClass: "project-groups__search-container__search col-6",
    attrs: {
      "type": "text",
      "placeholder": _vm.$t('message.group_search_input_placeholder')
    },
    on: {
      "input": _vm.onSearch
    },
    model: {
      value: _vm.query,
      callback: function ($$v) {
        _vm.query = $$v;
      },
      expression: "query"
    }
  }, [_c('template', {
    slot: "prepend"
  }, [_c('i', {
    staticClass: "icon icon-search"
  })])], 2), _vm._v(" "), _vm.isGroupSelected ? _c('div', {
    staticClass: "project-groups__selected-group"
  }, [_vm._v("\n            " + _vm._s(_vm.groups[0].name) + "\n            "), _c('at-button', {
    staticClass: "project-groups__selected-group__clear",
    attrs: {
      "icon": "icon-x",
      "circle": "",
      "size": "small"
    },
    on: {
      "click": _vm.onSearch
    }
  })], 1) : _vm._e()], 1), _vm._v(" "), _c('div', {
    staticClass: "at-container"
  }, [Object.keys(_vm.groups).length && !_vm.isDataLoading ? _c('div', [_c('GroupCollapsable', {
    attrs: {
      "groups": _vm.groups
    },
    on: {
      "getTargetClickGroupAndChildren": _vm.getTargetClickGroupAndChildren,
      "reloadData": _vm.onSearch
    }
  }), _vm._v(" "), _c('div', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.hasNextPage,
      expression: "hasNextPage"
    }],
    ref: "load",
    staticClass: "option__infinite-loader"
  }, [_vm._v("\n                " + _vm._s(_vm.$t('field.loading_groups')) + " "), _c('i', {
    staticClass: "icon icon-loader"
  })])], 1) : _c('div', {
    staticClass: "at-container__inner no-data"
  }, [_vm.isDataLoading ? _c('preloader') : _vm._e(), _vm._v(" "), _c('span', [_vm._v(_vm._s(_vm.$t('message.no_data')))])], 1)])]);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/lodash.debounce/index.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash.debounce/index.js ***!
  \***********************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/**
 * lodash (Custom Build) <https://lodash.com/>
 * Build: `lodash modularize exports="npm" -o ./`
 * Copyright jQuery Foundation and other contributors <https://jquery.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */

/** Used as the `TypeError` message for "Functions" methods. */
var FUNC_ERROR_TEXT = 'Expected a function';

/** Used as references for various `Number` constants. */
var NAN = 0 / 0;

/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/** Used to match leading and trailing whitespace. */
var reTrim = /^\s+|\s+$/g;

/** Used to detect bad signed hexadecimal string values. */
var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

/** Used to detect binary string values. */
var reIsBinary = /^0b[01]+$/i;

/** Used to detect octal string values. */
var reIsOctal = /^0o[0-7]+$/i;

/** Built-in method references without a dependency on `root`. */
var freeParseInt = parseInt;

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof __webpack_require__.g == 'object' && __webpack_require__.g && __webpack_require__.g.Object === Object && __webpack_require__.g;

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var objectToString = objectProto.toString;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max,
    nativeMin = Math.min;

/**
 * Gets the timestamp of the number of milliseconds that have elapsed since
 * the Unix epoch (1 January 1970 00:00:00 UTC).
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Date
 * @returns {number} Returns the timestamp.
 * @example
 *
 * _.defer(function(stamp) {
 *   console.log(_.now() - stamp);
 * }, _.now());
 * // => Logs the number of milliseconds it took for the deferred invocation.
 */
var now = function() {
  return root.Date.now();
};

/**
 * Creates a debounced function that delays invoking `func` until after `wait`
 * milliseconds have elapsed since the last time the debounced function was
 * invoked. The debounced function comes with a `cancel` method to cancel
 * delayed `func` invocations and a `flush` method to immediately invoke them.
 * Provide `options` to indicate whether `func` should be invoked on the
 * leading and/or trailing edge of the `wait` timeout. The `func` is invoked
 * with the last arguments provided to the debounced function. Subsequent
 * calls to the debounced function return the result of the last `func`
 * invocation.
 *
 * **Note:** If `leading` and `trailing` options are `true`, `func` is
 * invoked on the trailing edge of the timeout only if the debounced function
 * is invoked more than once during the `wait` timeout.
 *
 * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
 * until to the next tick, similar to `setTimeout` with a timeout of `0`.
 *
 * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
 * for details over the differences between `_.debounce` and `_.throttle`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to debounce.
 * @param {number} [wait=0] The number of milliseconds to delay.
 * @param {Object} [options={}] The options object.
 * @param {boolean} [options.leading=false]
 *  Specify invoking on the leading edge of the timeout.
 * @param {number} [options.maxWait]
 *  The maximum time `func` is allowed to be delayed before it's invoked.
 * @param {boolean} [options.trailing=true]
 *  Specify invoking on the trailing edge of the timeout.
 * @returns {Function} Returns the new debounced function.
 * @example
 *
 * // Avoid costly calculations while the window size is in flux.
 * jQuery(window).on('resize', _.debounce(calculateLayout, 150));
 *
 * // Invoke `sendMail` when clicked, debouncing subsequent calls.
 * jQuery(element).on('click', _.debounce(sendMail, 300, {
 *   'leading': true,
 *   'trailing': false
 * }));
 *
 * // Ensure `batchLog` is invoked once after 1 second of debounced calls.
 * var debounced = _.debounce(batchLog, 250, { 'maxWait': 1000 });
 * var source = new EventSource('/stream');
 * jQuery(source).on('message', debounced);
 *
 * // Cancel the trailing debounced invocation.
 * jQuery(window).on('popstate', debounced.cancel);
 */
function debounce(func, wait, options) {
  var lastArgs,
      lastThis,
      maxWait,
      result,
      timerId,
      lastCallTime,
      lastInvokeTime = 0,
      leading = false,
      maxing = false,
      trailing = true;

  if (typeof func != 'function') {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  wait = toNumber(wait) || 0;
  if (isObject(options)) {
    leading = !!options.leading;
    maxing = 'maxWait' in options;
    maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
    trailing = 'trailing' in options ? !!options.trailing : trailing;
  }

  function invokeFunc(time) {
    var args = lastArgs,
        thisArg = lastThis;

    lastArgs = lastThis = undefined;
    lastInvokeTime = time;
    result = func.apply(thisArg, args);
    return result;
  }

  function leadingEdge(time) {
    // Reset any `maxWait` timer.
    lastInvokeTime = time;
    // Start the timer for the trailing edge.
    timerId = setTimeout(timerExpired, wait);
    // Invoke the leading edge.
    return leading ? invokeFunc(time) : result;
  }

  function remainingWait(time) {
    var timeSinceLastCall = time - lastCallTime,
        timeSinceLastInvoke = time - lastInvokeTime,
        result = wait - timeSinceLastCall;

    return maxing ? nativeMin(result, maxWait - timeSinceLastInvoke) : result;
  }

  function shouldInvoke(time) {
    var timeSinceLastCall = time - lastCallTime,
        timeSinceLastInvoke = time - lastInvokeTime;

    // Either this is the first call, activity has stopped and we're at the
    // trailing edge, the system time has gone backwards and we're treating
    // it as the trailing edge, or we've hit the `maxWait` limit.
    return (lastCallTime === undefined || (timeSinceLastCall >= wait) ||
      (timeSinceLastCall < 0) || (maxing && timeSinceLastInvoke >= maxWait));
  }

  function timerExpired() {
    var time = now();
    if (shouldInvoke(time)) {
      return trailingEdge(time);
    }
    // Restart the timer.
    timerId = setTimeout(timerExpired, remainingWait(time));
  }

  function trailingEdge(time) {
    timerId = undefined;

    // Only invoke if we have `lastArgs` which means `func` has been
    // debounced at least once.
    if (trailing && lastArgs) {
      return invokeFunc(time);
    }
    lastArgs = lastThis = undefined;
    return result;
  }

  function cancel() {
    if (timerId !== undefined) {
      clearTimeout(timerId);
    }
    lastInvokeTime = 0;
    lastArgs = lastCallTime = lastThis = timerId = undefined;
  }

  function flush() {
    return timerId === undefined ? result : trailingEdge(now());
  }

  function debounced() {
    var time = now(),
        isInvoking = shouldInvoke(time);

    lastArgs = arguments;
    lastThis = this;
    lastCallTime = time;

    if (isInvoking) {
      if (timerId === undefined) {
        return leadingEdge(lastCallTime);
      }
      if (maxing) {
        // Handle invocations in a tight loop.
        timerId = setTimeout(timerExpired, wait);
        return invokeFunc(lastCallTime);
      }
    }
    if (timerId === undefined) {
      timerId = setTimeout(timerExpired, wait);
    }
    return result;
  }
  debounced.cancel = cancel;
  debounced.flush = flush;
  return debounced;
}

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return !!value && (type == 'object' || type == 'function');
}

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return !!value && typeof value == 'object';
}

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && objectToString.call(value) == symbolTag);
}

/**
 * Converts `value` to a number.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {number} Returns the number.
 * @example
 *
 * _.toNumber(3.2);
 * // => 3.2
 *
 * _.toNumber(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toNumber(Infinity);
 * // => Infinity
 *
 * _.toNumber('3.2');
 * // => 3.2
 */
function toNumber(value) {
  if (typeof value == 'number') {
    return value;
  }
  if (isSymbol(value)) {
    return NAN;
  }
  if (isObject(value)) {
    var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
    value = isObject(other) ? (other + '') : other;
  }
  if (typeof value != 'string') {
    return value === 0 ? value : +value;
  }
  value = value.replace(reTrim, '');
  var isBinary = reIsBinary.test(value);
  return (isBinary || reIsOctal.test(value))
    ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
    : (reIsBadHex.test(value) ? NAN : +value);
}

module.exports = debounce;


/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=style&index=0&id=fd8f5072&lang=scss&scoped=true":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=style&index=0&id=fd8f5072&lang=scss&scoped=true ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=style&index=0&id=2f82abd6&lang=scss&scoped=true":
/*!*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=style&index=0&id=2f82abd6&lang=scss&scoped=true ***!
  \*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=style&index=0&id=e17ffff2&lang=scss&scoped=true":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=style&index=0&id=e17ffff2&lang=scss&scoped=true ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue":
/*!***************************************************************************************!*\
  !*** ./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _GroupCollapsable_vue_vue_type_template_id_fd8f5072_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./GroupCollapsable.vue?vue&type=template&id=fd8f5072&scoped=true */ "./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=template&id=fd8f5072&scoped=true");
/* harmony import */ var _GroupCollapsable_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./GroupCollapsable.vue?vue&type=script&lang=js */ "./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=script&lang=js");
/* harmony import */ var _GroupCollapsable_vue_vue_type_style_index_0_id_fd8f5072_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./GroupCollapsable.vue?vue&type=style&index=0&id=fd8f5072&lang=scss&scoped=true */ "./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=style&index=0&id=fd8f5072&lang=scss&scoped=true");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _GroupCollapsable_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _GroupCollapsable_vue_vue_type_template_id_fd8f5072_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render,
  _GroupCollapsable_vue_vue_type_template_id_fd8f5072_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "fd8f5072",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue":
/*!************************************************************************************!*\
  !*** ./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _GroupProjects_vue_vue_type_template_id_2f82abd6_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./GroupProjects.vue?vue&type=template&id=2f82abd6&scoped=true */ "./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=template&id=2f82abd6&scoped=true");
/* harmony import */ var _GroupProjects_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./GroupProjects.vue?vue&type=script&lang=js */ "./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=script&lang=js");
/* harmony import */ var _GroupProjects_vue_vue_type_style_index_0_id_2f82abd6_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./GroupProjects.vue?vue&type=style&index=0&id=2f82abd6&lang=scss&scoped=true */ "./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=style&index=0&id=2f82abd6&lang=scss&scoped=true");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _GroupProjects_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _GroupProjects_vue_vue_type_template_id_2f82abd6_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render,
  _GroupProjects_vue_vue_type_template_id_2f82abd6_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "2f82abd6",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue":
/*!*******************************************************************************!*\
  !*** ./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue ***!
  \*******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _ProjectGroups_vue_vue_type_template_id_e17ffff2_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ProjectGroups.vue?vue&type=template&id=e17ffff2&scoped=true */ "./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=template&id=e17ffff2&scoped=true");
/* harmony import */ var _ProjectGroups_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ProjectGroups.vue?vue&type=script&lang=js */ "./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=script&lang=js");
/* harmony import */ var _ProjectGroups_vue_vue_type_style_index_0_id_e17ffff2_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ProjectGroups.vue?vue&type=style&index=0&id=e17ffff2&lang=scss&scoped=true */ "./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=style&index=0&id=e17ffff2&lang=scss&scoped=true");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _ProjectGroups_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _ProjectGroups_vue_vue_type_template_id_e17ffff2_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render,
  _ProjectGroups_vue_vue_type_template_id_e17ffff2_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "e17ffff2",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=script&lang=js":
/*!***************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=script&lang=js ***!
  \***************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_GroupCollapsable_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./GroupCollapsable.vue?vue&type=script&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=script&lang=js");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_GroupCollapsable_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=script&lang=js":
/*!************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=script&lang=js ***!
  \************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_GroupProjects_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./GroupProjects.vue?vue&type=script&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=script&lang=js");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_GroupProjects_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=script&lang=js":
/*!*******************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=script&lang=js ***!
  \*******************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ProjectGroups_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ProjectGroups.vue?vue&type=script&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=script&lang=js");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ProjectGroups_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=template&id=fd8f5072&scoped=true":
/*!*********************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=template&id=fd8f5072&scoped=true ***!
  \*********************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_GroupCollapsable_vue_vue_type_template_id_fd8f5072_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   staticRenderFns: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_GroupCollapsable_vue_vue_type_template_id_fd8f5072_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_GroupCollapsable_vue_vue_type_template_id_fd8f5072_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./GroupCollapsable.vue?vue&type=template&id=fd8f5072&scoped=true */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=template&id=fd8f5072&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=template&id=2f82abd6&scoped=true":
/*!******************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=template&id=2f82abd6&scoped=true ***!
  \******************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_GroupProjects_vue_vue_type_template_id_2f82abd6_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   staticRenderFns: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_GroupProjects_vue_vue_type_template_id_2f82abd6_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_GroupProjects_vue_vue_type_template_id_2f82abd6_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./GroupProjects.vue?vue&type=template&id=2f82abd6&scoped=true */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=template&id=2f82abd6&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=template&id=e17ffff2&scoped=true":
/*!*************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=template&id=e17ffff2&scoped=true ***!
  \*************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ProjectGroups_vue_vue_type_template_id_e17ffff2_scoped_true__WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   staticRenderFns: function() { return /* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ProjectGroups_vue_vue_type_template_id_e17ffff2_scoped_true__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_ProjectGroups_vue_vue_type_template_id_e17ffff2_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ProjectGroups.vue?vue&type=template&id=e17ffff2&scoped=true */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=template&id=e17ffff2&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=style&index=0&id=fd8f5072&lang=scss&scoped=true":
/*!************************************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=style&index=0&id=fd8f5072&lang=scss&scoped=true ***!
  \************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_clonedRuleSet_12_use_0_node_modules_laravel_mix_node_modules_css_loader_dist_cjs_js_clonedRuleSet_12_use_1_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_12_use_2_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_12_use_3_node_modules_sass_resources_loader_lib_loader_js_clonedRuleSet_12_use_4_node_modules_vue_loader_lib_index_js_vue_loader_options_GroupCollapsable_vue_vue_type_style_index_0_id_fd8f5072_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!../../../../../../node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!../../../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!../../../../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!../../../../../../node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./GroupCollapsable.vue?vue&type=style&index=0&id=fd8f5072&lang=scss&scoped=true */ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupCollapsable.vue?vue&type=style&index=0&id=fd8f5072&lang=scss&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=style&index=0&id=2f82abd6&lang=scss&scoped=true":
/*!*********************************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=style&index=0&id=2f82abd6&lang=scss&scoped=true ***!
  \*********************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_clonedRuleSet_12_use_0_node_modules_laravel_mix_node_modules_css_loader_dist_cjs_js_clonedRuleSet_12_use_1_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_12_use_2_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_12_use_3_node_modules_sass_resources_loader_lib_loader_js_clonedRuleSet_12_use_4_node_modules_vue_loader_lib_index_js_vue_loader_options_GroupProjects_vue_vue_type_style_index_0_id_2f82abd6_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!../../../../../../node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!../../../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!../../../../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!../../../../../../node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./GroupProjects.vue?vue&type=style&index=0&id=2f82abd6&lang=scss&scoped=true */ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/components/GroupProjects.vue?vue&type=style&index=0&id=2f82abd6&lang=scss&scoped=true");


/***/ }),

/***/ "./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=style&index=0&id=e17ffff2&lang=scss&scoped=true":
/*!****************************************************************************************************************************************!*\
  !*** ./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=style&index=0&id=e17ffff2&lang=scss&scoped=true ***!
  \****************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_mini_css_extract_plugin_dist_loader_js_clonedRuleSet_12_use_0_node_modules_laravel_mix_node_modules_css_loader_dist_cjs_js_clonedRuleSet_12_use_1_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_clonedRuleSet_12_use_2_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_12_use_3_node_modules_sass_resources_loader_lib_loader_js_clonedRuleSet_12_use_4_node_modules_vue_loader_lib_index_js_vue_loader_options_ProjectGroups_vue_vue_type_style_index_0_id_e17ffff2_lang_scss_scoped_true__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!../../../../../../node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!../../../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../../../node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!../../../../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!../../../../../../node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./ProjectGroups.vue?vue&type=style&index=0&id=e17ffff2&lang=scss&scoped=true */ "./node_modules/mini-css-extract-plugin/dist/loader.js??clonedRuleSet-12.use[0]!./node_modules/laravel-mix/node_modules/css-loader/dist/cjs.js??clonedRuleSet-12.use[1]!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-12.use[2]!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-12.use[3]!./node_modules/sass-resources-loader/lib/loader.js??clonedRuleSet-12.use[4]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/frontend/core/modules/ProjectGroups/views/ProjectGroups.vue?vue&type=style&index=0&id=e17ffff2&lang=scss&scoped=true");


/***/ })

}]);