<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Contracts\ScreenshotService;
use App\Models\TimeInterval;
use Illuminate\Support\Facades\Storage;

$service = app(ScreenshotService::class);
$intervals = TimeInterval::all();

echo "Found {$intervals->count()} intervals\n";

foreach ($intervals as $interval) {
    $screenshotPath = $service->getScreenshotPath($interval);
    $thumbPath = $service->getThumbPath($interval);
    
    if (Storage::exists($screenshotPath)) {
        if (!Storage::exists($thumbPath)) {
            echo "Creating thumbnail for interval {$interval->id}...\n";
            try {
                $service->createThumbnail($interval);
                echo "  ✓ Created!\n";
            } catch (Exception $e) {
                echo "  ✗ Error: {$e->getMessage()}\n";
            }
        } else {
            echo "Thumbnail already exists for interval {$interval->id}\n";
        }
    } else {
        echo "No screenshot found for interval {$interval->id}\n";
    }
}

echo "\nDone!\n";
