# Cattr cPanel Deployment Guide

## Before Uploading

1. **Build frontend assets locally** (if not building on server):

   ```bash
   npm install
   npm run prod
   ```

2. **Install composer dependencies locally** (if server doesn't have composer):

   ```bash
   composer install --optimize-autoloader --no-dev
   ```

3. **Create a zip file** of your project (excluding unnecessary files)

## Files to Upload

Upload these to your cPanel account (e.g., `/home/username/cattr/`):

- All Laravel files and folders
- `cpanelDeploy.sh` script
- Make sure `.env.example` is included

## Deployment Steps

### 1. Upload Files via cPanel File Manager or FTP

- Extract to: `/home/yourusername/cattr/`
- Keep `public/` folder separate or use `.htaccess` redirect

### 2. Access Terminal in cPanel

- Navigate to **Terminal** in cPanel
- Change to your app directory:

  ```bash
  cd ~/cattr
  ```

### 3. Make the script executable

```bash
chmod +x cpanelDeploy.sh
```

### 4. Run the deployment script

```bash
bash cpanelDeploy.sh
```

The script will:

- ✓ Check PHP version and extensions
- ✓ Create .env file from .env.example
- ✓ Install/update Composer dependencies
- ✓ Generate application key
- ✓ Create storage directories
- ✓ Set proper permissions
- ✓ Run database migrations
- ✓ Seed initial data
- ✓ Create admin user
- ✓ Optimize application (cache configs/routes/views)
- ✓ Create queue jobs table
- ✓ Build frontend assets (if npm available)

### 5. Configure .env File

Edit `.env` via cPanel File Manager or terminal:

```bash
nano .env
```

Update these values:

```env
APP_NAME=Cattr
APP_ENV=production
APP_DEBUG=false
APP_URL=https://yourdomain.com

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=your_database_name
DB_USERNAME=your_database_user
DB_PASSWORD=your_database_password

QUEUE_CONNECTION=database

SCREENSHOTS_STATE=any
```

Then clear cache:

```bash
php artisan config:cache
```

### 6. Setup Cron Job for Screenshot Thumbnails

**Critical Step!** In cPanel → Cron Jobs:

**Command:**

```bash
* * * * * cd /home/yourusername/cattr && /usr/bin/php artisan queue:work --stop-when-empty >> /dev/null 2>&1
```

**Or for Laravel scheduler:**

```bash
* * * * * cd /home/yourusername/cattr && /usr/bin/php artisan schedule:run >> /dev/null 2>&1
```

This runs every minute and processes queued jobs (thumbnail generation, etc.)

### 7. Configure Web Server Document Root

**Option A: Set Document Root (Recommended)**

- In cPanel → Domains → Manage
- Set document root to: `/home/yourusername/cattr/public`

**Option B: Use .htaccess Redirect**
Create/edit `public_html/.htaccess`:

```apache
<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteRule ^(.*)$ /cattr/public/$1 [L]
</IfModule>
```

### 8. Verify PHP Extensions

In cPanel → **Select PHP Version**, enable:

- [x] gd
- [x] zip
- [x] mbstring
- [x] pdo
- [x] pdo_mysql
- [x] openssl
- [x] json

### 9. Adjust PHP Settings (if needed)

In cPanel → **PHP Options** or php.ini:

```ini
memory_limit = 256M
upload_max_filesize = 10M
post_max_size = 10M
max_execution_time = 60
```

### 10. Test Your Installation

1. Visit your domain: `https://yourdomain.com`
2. Login with admin credentials
3. Upload a screenshot via desktop client
4. Wait 1 minute for cron to run
5. Check Screenshots page - should show thumbnails (not sad faces!)

## Troubleshooting

### Screenshots show sad faces

- Check if cron job is running: `crontab -l`
- Verify thumbnails directory exists: `ls -la storage/app/screenshots/thumbs/`
- Manually process queue: `php artisan queue:work --once`
- Check queue table: `SELECT * FROM jobs;`

### 500 Internal Server Error

- Check storage permissions: `chmod -R 775 storage bootstrap/cache`
- Check error logs: `tail -f storage/logs/laravel.log`
- Clear all caches: `php artisan cache:clear && php artisan config:clear`

### Database connection errors

- Verify database credentials in `.env`
- Check database exists in cPanel → MySQL Databases
- Ensure user has privileges on the database

### Can't run migrations

- Check database connection
- Verify MySQL user permissions
- Try: `php artisan migrate:fresh --force` (WARNING: drops all tables!)

### Queue jobs not processing

- Check cron job is set up correctly
- Verify `QUEUE_CONNECTION=database` in `.env`
- Check jobs table exists: `php artisan queue:table && php artisan migrate`
- Test manually: `php artisan queue:work --once`

## Manual Commands Reference

```bash
# Clear all caches
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear

# Rebuild caches
php artisan config:cache
php artisan route:cache
php artisan view:cache

# Check queue status
php artisan queue:monitor

# Process one queue job
php artisan queue:work --once

# Generate missing thumbnails
php generate_thumbnails.php

# Create admin user
php artisan cattr:make:admin

# Check application status
php artisan about
```

## File Permissions Checklist

```
storage/                    → 775
storage/app/                → 775
storage/app/screenshots/    → 775
storage/app/screenshots/thumbs/ → 775
storage/framework/          → 775
storage/logs/               → 775
bootstrap/cache/            → 775
```

## Support

- Documentation: <https://docs.cattr.app>
- Issues: <https://github.com/cattr-app/server-application/issues>
- Community: <https://community.cattr.app>

---

**After successful deployment**, remember to:

1. Test all features (login, projects, tasks, time tracking, screenshots)
2. Configure backup strategy for database and uploads
3. Set up SSL certificate (Let's Encrypt via cPanel)
4. Monitor error logs regularly
